<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <style>
        body {
            /*box-sizing: border-box;*/
            color: rgb(55, 61, 73);
            display: block;
            font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-size: 14px;
            font-weight: normal;
            /*height: 567px;*/
            line-height: 28px;
            margin: 0;
            /*width: 1734px;*/
            padding: 25px;
        }

        h1, h2, h3, h4, p {
            box-sizing: border-box;
            color: rgb(55, 61, 73);
            display: block;
            margin-top: 0px;
            /*width: 852px;*/
        }

        h1, h2, h3, h4 {
            font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-style: normal;
            font-weight: 600;
            /*line-height: 42px;*/
            margin-left: 0px;
            margin-right: 0px;
        }

        h1 {
            font-size: 29px;
            height: 53px;
            margin-bottom: 1px;
            padding-top: 11px;
        }

        h2 {
            font-size: 27px;
            height: 53px;
            margin-bottom: 2px;
            padding-top: 11px;
        }

        h3 {
            font-size: 23px;
            height: 53px;
            margin-bottom: 1px;
            padding-top: 11px;
        }

        h4 {
            font-size: 22px;
            height: 34px;
            margin-bottom: 8px;
            padding-top: 6px;
        }

        p {

            font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-size: 14px;
            font-weight: normal;
            line-height: 20px;
            margin-bottom: 18px;
            padding-top: 9px;
        }

        .label {
            font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-size: 14px;
            font-weight: bold;
        }

        .labeldescription {
            font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-size: 14px;
        }

        .headers {
            background-color: lightgrey;
            color: darkblue;
        }

        table {
            border-collapse: collapse;
            width: auto;
        }

        table, th, td {
            border: 1px solid darkslategrey;
        }

        th, td {
            padding: 3px;
            text-align: left;
        }

        ul {
            box-sizing: border-box;
            color: rgb(55, 61, 73);
            display: block;

            font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-size: 14px;
            font-weight: normal;
            line-height: 28px;
            margin-bottom: 11px;
            padding-top: 2px;
            width: 852px;
        }

        li {
            box-sizing: border-box;
            color: rgb(55, 61, 73);
            display: list-item;
            font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-size: 14px;
            font-weight: normal;
            line-height: 28px;
            margin-left: 14px;
            width: 798px;
        }
    </style>
</head>
<body>
<h3 class="headers">Overzicht testcases</h3>
<br/>
<table>
    <tbody>
    <#list wikipages as wikiPage>
        <#if wikiPage.purpose??>
            <tr>
            <td><a href="#${wikiPage.testcase}">${wikiPage.testcase}</a></td>
            <td>${wikiPage.purpose}</td></tr>
        <#else>
            <tr>
                <td colspan="2"><a href="#${wikiPage.testcase}">${wikiPage.testcase}</a></td>
            </tr>
        </#if>
    </#list>
    </tbody>
</table>
<br/>

<h3 class="headers">Details testcases</h3>
<#list wikipages as wikiPage>
    <h3><a name="${wikiPage.testcase}"></a>${wikiPage.testcase}</h3>

    <table>
        <tbody>
        <#if wikiPage.purpose??>
            <tr>
            <td class="label">Purpose</td>
            <td class="labeldescription">${wikiPage.purpose}</td>
            </tr></#if>
        <#if wikiPage.link??>
            <tr>
            <td class="label">Link</td>
            <td class="labeldescription"><a href="${wikiPage.link}" target="_blank">${wikiPage.link}</a></td>
            </tr></#if>
        <#if wikiPage.usecase??>
            <tr>
            <td class="label">Usecase</td>
            <td class="labeldescription">${wikiPage.usecase}</td>
            </tr></#if>
        <#if wikiPage.issue??>
            <tr>
            <td class="label">Issue</td>
            <td class="labeldescription">${wikiPage.issue}</td>
            </tr></#if>
        </tbody>
    </table>
    ${wikiPage.contents}
    <hr/>
    <br/>
</#list>
Generated on ${.now?datetime}
</body>
</html>