/*
 * Decompiled with CFR 0.152.
 */
package nl.lockhead.lpf.plugins.plugin;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import nl.lockhead.lpf.exceptions.InvalidPluginException;
import nl.lockhead.lpf.logging.LPFLogger;
import nl.lockhead.lpf.plugins.PluginManager;
import nl.lockhead.lpf.plugins.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PluginContainer {
    private final List<Method> events = new ArrayList<Method>();
    private Plugin plugin;

    public PluginContainer(@NotNull Plugin plugin) throws InvalidPluginException {
        this.loadPlugin(plugin);
    }

    public void loadPlugin(@NotNull Plugin plugin) throws InvalidPluginException {
        if (plugin.isLoaded()) {
            System.err.println("The plugin is already loaded!");
            return;
        }
        plugin.load();
        plugin.setContainer(this);
        this.plugin = plugin;
    }

    public void unloadPlugin() {
        if (!this.plugin.isLoaded()) {
            System.err.println("The plugin is already unloaded!");
            return;
        }
        this.plugin.unload();
        PluginManager.get().getPlugins().remove(this);
        LPFLogger.getLogger(PluginManager.get()).info("Unloaded " + this.plugin.getConfig().getName() + " v" + this.plugin.getConfig().getVersion());
    }

    public void enablePlugin() {
        if (!this.plugin.isLoaded()) {
            System.err.println("The plugin is not loaded yet!");
            return;
        }
        if (this.plugin.isEnabled()) {
            System.err.println("The plugin is already enabled!");
            return;
        }
        this.plugin.enable();
        LPFLogger.getLogger(PluginManager.get()).info("Enabled " + this.plugin.getConfig().getName() + " v" + this.plugin.getConfig().getVersion());
    }

    public void disablePlugin() {
        if (!this.plugin.isLoaded()) {
            System.err.println("The plugin is not loaded yet!");
            return;
        }
        if (!this.plugin.isEnabled()) {
            System.err.println("The plugin is already disabled!");
            return;
        }
        this.plugin.disable();
        LPFLogger.getLogger(PluginManager.get()).info("Disabled " + this.plugin.getConfig().getName() + " v" + this.plugin.getConfig().getVersion());
    }

    public List<Method> getEventMethods() {
        return new ArrayList<Method>(this.events);
    }

    public List<Method> addEventMethod(Method eventMethod) {
        this.events.add(eventMethod);
        return this.getEventMethods();
    }

    public final Plugin getPlugin() {
        return this.plugin;
    }
}

