/*
 * Decompiled with CFR 0.152.
 */
package nl.lockhead.lpf.plugins.plugin;

import nl.lockhead.lpf.events.LPFEventHandler;
import nl.lockhead.lpf.events.builtin.PluginDisableEvent;
import nl.lockhead.lpf.events.builtin.PluginEnableEvent;
import nl.lockhead.lpf.exceptions.InvalidPluginException;
import nl.lockhead.lpf.logging.LPFLogger;
import nl.lockhead.lpf.plugins.PluginManager;
import nl.lockhead.lpf.plugins.annotations.PluginInfo;
import nl.lockhead.lpf.plugins.plugin.PluginConfig;
import nl.lockhead.lpf.plugins.plugin.PluginContainer;
import nl.lockhead.lpf.plugins.plugin.Version;
import nl.lockhead.lpf.plugins.threads.LPFThread;

public abstract class Plugin {
    private static Integer idCounter = 0;
    private final Integer id;
    private PluginConfig config;
    private transient PluginContainer container;
    private boolean enabled;
    private boolean loaded;
    private boolean eventsRegistered;

    protected Plugin() {
        Integer n = idCounter;
        Integer n2 = idCounter = Integer.valueOf(idCounter + 1);
        this.id = n;
    }

    public void onLoad() {
    }

    public void onUnload() {
    }

    public abstract void onEnable();

    public abstract void onDisable();

    protected final void load() throws InvalidPluginException {
        if (this.loaded) {
            LPFLogger.getLogger(this).warning("Plugin " + this.config.getName() + " failed to load: Plugin was already loaded.");
            return;
        }
        this.config = this.loadConfig();
        LPFThread thread = new LPFThread(this::onLoad, LPFThread.ThreadType.LOAD);
        thread.start();
        this.loaded = true;
        try {
            if (this.config.shouldRegisterEvents()) {
                this.registerEvents();
            }
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            this.loaded = false;
        }
    }

    private PluginConfig loadConfig() throws InvalidPluginException {
        Class<?> obj = this.getClass();
        if (obj.isAnnotationPresent(PluginInfo.class)) {
            PluginInfo a = obj.getAnnotation(PluginInfo.class);
            return PluginConfig.createConfig(a.name(), a.author(), Version.getVersion(a.version()));
        }
        throw new InvalidPluginException("Plugin (instanceId=" + this.id + ") failed to load: @PluginInfo annotation not present.");
    }

    protected final void registerEvents() {
        if (this.eventsRegistered) {
            this.getLogger().warning("Plugin (instanceId=" + this.id + ") failed to register event listeners: Events already registered.");
            return;
        }
        if (!this.loaded) {
            throw new IllegalStateException("Plugin (instanceId=" + this.id + ") failed to register event listeners: Plugin not loaded yet.");
        }
        PluginManager.get().registerEvents(this);
        this.eventsRegistered = true;
    }

    public final void unload() {
        if (this.enabled) {
            LPFLogger.getLogger(this).warning("Plugin (name=" + this.config.getName() + ") failed to unload: Plugin needs to be disabled first.");
            return;
        }
        if (!this.loaded) {
            LPFLogger.getLogger(this).warning("Plugin (instanceId=" + this.id + ") failed to unload: Plugin was already unloaded.");
            return;
        }
        LPFThread thread = new LPFThread(this::onUnload, LPFThread.ThreadType.UNLOAD);
        thread.start();
        if (this.eventsRegistered) {
            for (PluginContainer pc : PluginManager.get().getRegisteredEvents().keySet()) {
                if (pc.getPlugin().getId() != this.id.intValue()) continue;
                PluginManager.get().getRegisteredEvents().remove(pc);
                break;
            }
            this.eventsRegistered = false;
        }
        this.loaded = false;
    }

    public final void enable() {
        if (!this.loaded) {
            LPFLogger.getLogger(this).warning("Plugin (instanceId=" + this.id + ") failed to enable: Plugin not loaded yet.");
            return;
        }
        if (this.enabled) {
            LPFLogger.getLogger(this).warning("Plugin " + this.config.getName() + " failed to enable: Plugin already enabled.");
            return;
        }
        LPFEventHandler.getLPFEventHandler().handleEvent(new PluginEnableEvent(this));
        LPFThread thread = new LPFThread(this::onEnable, LPFThread.ThreadType.ENABLE);
        thread.start();
        this.enabled = true;
    }

    public final void disable() {
        if (!this.loaded) {
            LPFLogger.getLogger(this).warning("Plugin (instanceId=" + this.id + ") failed to disable: Plugin not loaded yet.");
            return;
        }
        if (!this.enabled) {
            LPFLogger.getLogger(this).warning("Plugin " + this.config.getName() + " failed to disable: Plugin already disabled.");
            return;
        }
        LPFEventHandler.getLPFEventHandler().handleEvent(new PluginDisableEvent(this));
        LPFThread thread = new LPFThread(this::onDisable, LPFThread.ThreadType.DISABLE);
        thread.start();
        this.enabled = false;
    }

    public final boolean isLoaded() {
        return this.loaded;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final boolean isEventsRegistered() {
        return this.eventsRegistered;
    }

    public final int getId() {
        return this.id;
    }

    protected final LPFLogger getLogger() {
        return LPFLogger.getLogger(this);
    }

    public PluginConfig getConfig() {
        return this.config;
    }

    public PluginContainer getContainer() {
        return this.container;
    }

    protected void setContainer(PluginContainer container) {
        this.container = container;
    }
}

