/*
 * Decompiled with CFR 0.152.
 */
package nl.lockhead.lpf.logging;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import nl.lockhead.lpf.plugins.annotations.LoggerSettings;
import nl.lockhead.lpf.plugins.plugin.Plugin;
import nl.lockhead.lpf.tools.Matching;
import org.jetbrains.annotations.Nullable;

public class LPFLogger {
    private static final ConsoleHandler consoleHandler = new ConsoleHandler();
    private static Handler defaultHandler;
    private static List<LPFLogger> loggers;
    private static LPFLogger defaultLogger;
    private static int indentation;
    private final Object source;
    private Logger logger;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SS");

    private LPFLogger(@Nullable Object source) {
        String name = "LPF";
        if (source != null) {
            Class<?> clazz;
            name = source instanceof String ? (String)source : (source instanceof Plugin ? (((Plugin)source).getConfig() != null ? ((Plugin)source).getConfig().getName() : "Plugin ID " + ((Plugin)source).getId()) : ((clazz = source.getClass()).isAnnotationPresent(LoggerSettings.class) ? clazz.getAnnotation(LoggerSettings.class).displayName() : source.getClass().getSimpleName()));
        }
        this.logger = Logger.getLogger(name);
        this.logger.setUseParentHandlers(false);
        this.logger.setLevel(Level.ALL);
        if (defaultHandler != null) {
            defaultHandler.setLevel(Level.ALL);
            this.logger.addHandler(defaultHandler);
        }
        indentation = Math.max(indentation, name.length());
        this.source = source;
        loggers.add(this);
    }

    public static LPFLogger getLogger(@Nullable Object source) {
        if (source == null) {
            if (defaultLogger == null) {
                defaultLogger = new LPFLogger(null);
                defaultLogger.addHandler(consoleHandler);
            }
            return defaultLogger;
        }
        for (LPFLogger l : loggers) {
            if (l.source == null || !l.source.equals(source)) continue;
            return l;
        }
        LPFLogger l = new LPFLogger(source);
        l.addHandler(consoleHandler);
        return l;
    }

    public static void addHandlerToAll(Handler handler) {
        if (defaultLogger == null) {
            defaultLogger = new LPFLogger(null);
        }
        defaultLogger.addHandler(handler);
        for (LPFLogger l : loggers) {
            if (l.source == null) continue;
            l.addHandler(handler);
        }
    }

    public static void removeLogger(LPFLogger logger) {
        loggers.remove(logger);
    }

    public static Handler getDefaultHandler() {
        return defaultHandler;
    }

    public static void setDefaultHandler(Handler defaultHandler) {
        LPFLogger.defaultHandler = defaultHandler;
    }

    public static List<LPFLogger> getLoggers() {
        return loggers;
    }

    public void removeLogger() {
        loggers.remove(this);
    }

    public Handler addHandler(Handler handler) {
        handler.setLevel(Level.ALL);
        handler.setFormatter(new SimpleFormatter(){

            @Override
            public String format(LogRecord record) {
                if (LPFLogger.this.getSource() == null) {
                    return String.format("%s [%s:%s] %s\n", LPFLogger.this.dateFormat.format(new Date(record.getMillis())), record.getLoggerName(), record.getSourceMethodName().toUpperCase(), record.getMessage());
                }
                if (LPFLogger.this.getSource() instanceof Plugin) {
                    Plugin p = (Plugin)LPFLogger.this.getSource();
                    String name = p.getConfig() == null ? "Plugin ID " + p.getId() : p.getConfig().getName();
                    return String.format("%s [%s:%s] %s\n", LPFLogger.this.dateFormat.format(new Date(record.getMillis())), name, record.getSourceMethodName().toUpperCase(), record.getMessage());
                }
                return String.format("%s [%s:%s] %s\n", LPFLogger.this.dateFormat.format(new Date(record.getMillis())), record.getLoggerName(), record.getSourceMethodName().toUpperCase(), record.getMessage());
            }
        });
        this.logger.addHandler(handler);
        return handler;
    }

    public void info(Object message) {
        String m = String.valueOf(message);
        for (String s : Matching.MATCH_NEWLINE.split(m)) {
            this.logger.log(Level.INFO, s);
        }
    }

    public void severe(Object message) {
        String m = String.valueOf(message);
        for (String s : Matching.MATCH_NEWLINE.split(m)) {
            this.logger.log(Level.SEVERE, s);
        }
    }

    public void warning(Object message) {
        String m = String.valueOf(message);
        for (String s : Matching.MATCH_NEWLINE.split(m)) {
            this.logger.log(Level.WARNING, s);
        }
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(SimpleDateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Object getSource() {
        return this.source;
    }

    static {
        loggers = new ArrayList<LPFLogger>();
        indentation = 0;
    }
}

