/*
 * Decompiled with CFR 0.152.
 */
package nl.lockhead.lpf.plugins.loaders.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import nl.lockhead.lpf.plugins.loaders.IPluginLoader;
import nl.lockhead.lpf.plugins.plugin.Plugin;
import nl.lockhead.lpf.plugins.plugin.PluginContainer;

public class URLPluginLoader
implements IPluginLoader {
    protected final URL[] urls;
    protected boolean running;

    public URLPluginLoader(URL ... urls) {
        this.urls = urls;
    }

    @Override
    public Set<PluginContainer> loadPlugins() {
        return this.loadPlugins(this.urls);
    }

    protected Set<PluginContainer> loadPlugins(URL ... urls) {
        if (!this.running) {
            this.running = true;
            HashSet<PluginContainer> loaded = new HashSet<PluginContainer>();
            for (URL url : urls) {
                try {
                    PluginContainer pc = new PluginContainer(this.getPlugin(url));
                    loaded.add(pc);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return loaded;
        }
        System.err.print("A plugin loader instance is already running!");
        return Collections.emptySet();
    }

    protected Plugin getPlugin(URL url) throws IOException {
        int nRead;
        URLConnection conn = url.openConnection();
        conn.setConnectTimeout(3000);
        conn.addRequestProperty("User-Agent", "Mozilla/5.0 (X11; Linux x86_64; rv:56.0) Gecko/20100101 Firefox/56.0");
        conn.connect();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        InputStream is = conn.getInputStream();
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        return this.readBuffer(buffer.toByteArray());
    }

    protected Plugin readBuffer(byte[] buffer) throws IOException {
        final HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        try (JarInputStream is = new JarInputStream(new ByteArrayInputStream(buffer));){
            JarEntry nextEntry;
            while ((nextEntry = is.getNextJarEntry()) != null) {
                int est = (int)nextEntry.getSize();
                byte[] data = new byte[est > 0 ? est : 1024];
                int real = 0;
                int r = is.read(data);
                while (r > 0) {
                    if (data.length == (real += r)) {
                        data = Arrays.copyOf(data, data.length * 2);
                    }
                    r = is.read(data, real, data.length - real);
                }
                if (real != data.length) {
                    data = Arrays.copyOf(data, real);
                }
                map.put("/" + nextEntry.getName(), data);
            }
        }
        URL u = new URL("x-buffer", null, -1, "/", new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL u) throws IOException {
                final byte[] data = (byte[])map.get(u.getFile());
                if (data == null) {
                    throw new FileNotFoundException(u.getFile());
                }
                return new URLConnection(u){

                    @Override
                    public void connect() {
                    }

                    @Override
                    public InputStream getInputStream() {
                        return new ByteArrayInputStream(data);
                    }
                };
            }
        });
        Plugin plugin = null;
        URL[] urls = new URL[]{u};
        try (URLClassLoader cl = URLClassLoader.newInstance(urls);){
            for (String s : map.keySet()) {
                if (!s.endsWith(".class")) continue;
                String classpath = s.substring(1).replace('/', '.').replace(".class", "");
                try {
                    System.out.println("classpath = " + classpath);
                    Class<?> c = cl.loadClass(classpath);
                    System.out.println("c = " + c);
                    System.out.println("c.getSuperclass() = " + c.getSuperclass());
                    if (c.getSuperclass() != Plugin.class) continue;
                    plugin = (Plugin)c.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    System.out.println("s = " + s);
                    e.printStackTrace();
                }
            }
            Iterator iterator = plugin;
            return iterator;
        }
    }

    public URL[] getUrls() {
        return this.urls;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }
}

