/*
 * Decompiled with CFR 0.152.
 */
package nl.lockhead.lpf.plugins.loaders.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import nl.lockhead.lpf.exceptions.InvalidPluginException;
import nl.lockhead.lpf.plugins.loaders.impl.URLPluginLoader;
import nl.lockhead.lpf.plugins.plugin.Plugin;
import nl.lockhead.lpf.plugins.plugin.PluginContainer;

public class AsyncURLPluginLoader
extends URLPluginLoader {
    private ExecutorService executor;

    public AsyncURLPluginLoader(URL ... urls) {
        super(urls);
        this.executor = Executors.newFixedThreadPool(Math.min(16, Math.max(1, urls.length / 4)));
    }

    @Override
    public Set<PluginContainer> loadPlugins() {
        return this.loadPlugins(this.urls);
    }

    @Override
    public Set<PluginContainer> loadPlugins(URL ... urls) {
        if (!this.running) {
            this.running = true;
            ArrayList callables = new ArrayList();
            Arrays.stream(urls).forEach(url -> callables.add(() -> {
                try {
                    return new PluginContainer(this.getPlugin((URL)url));
                }
                catch (InvalidPluginException e) {
                    e.printStackTrace();
                    return null;
                }
            }));
            try {
                Set<PluginContainer> result = this.executor.invokeAll(callables).stream().map(future -> {
                    try {
                        return (PluginContainer)future.get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                        return null;
                    }
                }).filter(Objects::nonNull).collect(Collectors.toSet());
                this.running = false;
                return result;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            System.err.print("A plugin loader instance is already running!");
        }
        return Collections.emptySet();
    }

    @Override
    protected Plugin getPlugin(URL url) {
        try {
            System.out.println("url = " + url);
            return super.getPlugin(url);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }
}

