package nl.lockhead.lpf.plugins.annotations;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Apply custom settings for the logger instance associated with a source class.
 * Unable to use with Plugin classes.
 *
 * @author lkhd
 */
@Retention(RUNTIME)
@Target(TYPE)
public @interface LoggerSettings {

    /**
     * The name to use as prefix.
     *
     * @return the name show in the prefix
     */
    String displayName();
}
