package nl.lockhead.lpf.events;

import nl.lockhead.lpf.plugins.PluginManager;
import nl.lockhead.lpf.plugins.annotations.PluginEvent;
import nl.lockhead.lpf.plugins.plugin.PluginContainer;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class LPFEventHandler {

    private static LPFEventHandler lpfEventHandler;

    public static LPFEventHandler getLPFEventHandler() {
        return lpfEventHandler == null ? (lpfEventHandler = new LPFEventHandler()) : lpfEventHandler;
    }

    /**
     * Handle the given event. Iterate over methods annotated with {@link PluginEvent} and invoke them.
     *
     * @param event the event to handle
     */
    public synchronized void handleEvent(LPFEvent event) {
        int listeners = 0;
        for (PluginContainer pc : PluginManager.get().getRegisteredEvents().keySet())
            if (pc.getPlugin().isEnabled() && pc.getPlugin().isLoaded() && pc.getPlugin().isEventsRegistered()) {
                HashMap<Class<? extends LPFEvent>, Method> m = PluginManager.get().getRegisteredEvents().get(pc);

                for (Map.Entry<Class<? extends LPFEvent>, Method> entry : m.entrySet()) {
                    Method method = entry.getValue();
                    if (event.getClass() == entry.getKey())
                        try {
                            method.invoke(pc.getPlugin(), event);
                            listeners++;
                        } catch (IllegalAccessException | InvocationTargetException | IllegalArgumentException e1) {
                            e1.printStackTrace();
                        }
                }
            }
    }
}
