/*
 * Decompiled with CFR 0.152.
 */
package nl.fizzit.maven.plugins.tstamp;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import nl.fizzit.maven.plugins.tstamp.Format;
import nl.fizzit.maven.plugins.tstamp.Unit;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TStampMojo
extends AbstractMojo {
    public static final String DSTAMP_PROPERTY_NAME = "DSTAMP";
    public static final String DSTAMP_PROPERTY_FORMAT = "yyyyMMdd";
    public static final String HSTAMP_PROPERTY_NAME = "HSTAMP";
    public static final String HSTAMP_PROPERTY_FORMAT = "hhmm";
    public static final String TODAY_PROPERTY_NAME = "TODAY";
    public static final String TODAY_PROPERTY_FORMAT = "MMMM dd yyyy";
    private MavenProject project;
    private List<Format> formats;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.execute(new Date());
        }
        catch (Exception e) {
            this.getLog().debug((Throwable)e);
            throw new MojoFailureException(String.format("Exception occurred %s: %s", e.getClass().getName(), e.getMessage()));
        }
    }

    void execute(Date date) throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Setting TStamp properties");
        SimpleDateFormat dStampFormatter = new SimpleDateFormat(DSTAMP_PROPERTY_FORMAT);
        this.exportProperty(DSTAMP_PROPERTY_NAME, dStampFormatter.format(date));
        SimpleDateFormat hStampFormatter = new SimpleDateFormat(HSTAMP_PROPERTY_FORMAT);
        this.exportProperty(HSTAMP_PROPERTY_NAME, hStampFormatter.format(date));
        SimpleDateFormat todayFormatter = new SimpleDateFormat(TODAY_PROPERTY_FORMAT);
        this.exportProperty(TODAY_PROPERTY_NAME, todayFormatter.format(date));
        if (this.formats != null) {
            for (Format format : this.formats) {
                this.getLog().info((CharSequence)"-- Exporting custom format");
                this.exportFormattedProperty(format, date);
            }
        }
        this.getLog().info((CharSequence)"TStamp properties set");
    }

    private void exportFormattedProperty(Format format, Date date) {
        this.assertNotNull(format.property);
        this.assertNotNull(format.pattern);
        TimeZone timezone = TimeZone.getDefault();
        if (format.timezone != null) {
            timezone = TimeZone.getTimeZone(format.timezone);
            this.getLog().info((CharSequence)String.format("Using timezone: %s", timezone.getDisplayName()));
        }
        Locale locale = Locale.getDefault();
        if (format.locale != null) {
            String[] bits = format.locale.split(",");
            if (bits.length == 1) {
                locale = new Locale(bits[0]);
            } else if (bits.length == 2) {
                locale = new Locale(bits[0], bits[1]);
            } else {
                throw new IllegalArgumentException(String.format("Invalid input for locale: %s", format.locale));
            }
            this.getLog().info((CharSequence)String.format("Using locale: %s", locale.getDisplayName()));
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (format.offset != 0 && format.unit != null) {
            Unit unit = Unit.fromString(format.unit);
            if (unit == null) {
                throw new IllegalArgumentException(String.format("Invalid input for unit: %s", format.unit));
            }
            this.getLog().info((CharSequence)String.format("Adjusting time offset %s (unit %s)", format.offset, unit.value));
            cal.add(unit.fieldNumber, format.offset);
        }
        SimpleDateFormat customFormatter = new SimpleDateFormat(format.pattern, locale);
        customFormatter.setTimeZone(timezone);
        this.exportProperty(format.property, customFormatter.format(cal.getTime()));
    }

    private void exportProperty(String key, String value) {
        if (this.project.getProperties().put(key, value) != null) {
            this.getLog().warn((CharSequence)String.format("Property key \"%s\" replaced an existing entry.", key));
        }
        this.getLog().info((CharSequence)String.format("Property %s set to %s", key, value));
    }

    private void assertNotNull(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Value not allowed to be null");
        }
    }

    public void setFormats(List<Format> formats) {
        this.formats = formats;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }
}

