/*
 * Decompiled with CFR 0.152.
 */
package nl.dionsegijn.konfetti.xml;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nl.dionsegijn.konfetti.core.Particle;
import nl.dionsegijn.konfetti.core.Party;
import nl.dionsegijn.konfetti.core.PartySystem;
import nl.dionsegijn.konfetti.xml.DrawShapesKt;
import nl.dionsegijn.konfetti.xml.listeners.OnParticleSystemUpdateListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u00014B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B#\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J(\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\tH\u0014J\u0018\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020\tH\u0014J\u0006\u0010)\u001a\u00020\u001eJ\u001f\u0010*\u001a\u00020\u001e2\u0012\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020-0,\"\u00020-\u00a2\u0006\u0002\u0010.J\u0014\u0010*\u001a\u00020\u001e2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0/J\u000e\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020-J\u000e\u00100\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020-J\u0006\u00101\u001a\u00020\u001eJ\u0014\u00102\u001a\u00020\u001e*\u0002032\u0006\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lnl/dionsegijn/konfetti/xml/KonfettiView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "drawArea", "Landroid/graphics/Rect;", "onParticleSystemUpdateListener", "Lnl/dionsegijn/konfetti/xml/listeners/OnParticleSystemUpdateListener;", "getOnParticleSystemUpdateListener", "()Lnl/dionsegijn/konfetti/xml/listeners/OnParticleSystemUpdateListener;", "setOnParticleSystemUpdateListener", "(Lnl/dionsegijn/konfetti/xml/listeners/OnParticleSystemUpdateListener;)V", "paint", "Landroid/graphics/Paint;", "systems", "", "Lnl/dionsegijn/konfetti/core/PartySystem;", "timer", "Lnl/dionsegijn/konfetti/xml/KonfettiView$TimerIntegration;", "getActiveSystems", "isActive", "", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "onSizeChanged", "w", "h", "oldw", "oldh", "onVisibilityChanged", "changedView", "visibility", "reset", "start", "party", "", "Lnl/dionsegijn/konfetti/core/Party;", "([Lnl/dionsegijn/konfetti/core/Party;)V", "", "stop", "stopGracefully", "display", "Lnl/dionsegijn/konfetti/core/Particle;", "TimerIntegration", "xml_release"})
@SourceDebugExtension(value={"SMAP\nKonfettiView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KonfettiView.kt\nnl/dionsegijn/konfetti/xml/KonfettiView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,184:1\n1855#2,2:185\n1549#2:191\n1620#2,3:192\n1855#2,2:195\n11335#3:187\n11670#3,3:188\n*S KotlinDebug\n*F\n+ 1 KonfettiView.kt\nnl/dionsegijn/konfetti/xml/KonfettiView\n*L\n60#1:185,2\n108#1:191\n108#1:192,3\n145#1:195,2\n98#1:187\n98#1:188,3\n*E\n"})
public class KonfettiView
extends View {
    @NotNull
    private final List<PartySystem> systems = new ArrayList();
    @NotNull
    private TimerIntegration timer = new TimerIntegration();
    @NotNull
    private Rect drawArea = new Rect();
    @Nullable
    private OnParticleSystemUpdateListener onParticleSystemUpdateListener;
    @NotNull
    private final Paint paint = new Paint();

    public KonfettiView(@Nullable Context context) {
        super(context);
    }

    public KonfettiView(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public KonfettiView(@Nullable Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Nullable
    public final OnParticleSystemUpdateListener getOnParticleSystemUpdateListener() {
        return this.onParticleSystemUpdateListener;
    }

    public final void setOnParticleSystemUpdateListener(@Nullable OnParticleSystemUpdateListener onParticleSystemUpdateListener) {
        this.onParticleSystemUpdateListener = onParticleSystemUpdateListener;
    }

    @NotNull
    public final List<PartySystem> getActiveSystems() {
        return this.systems;
    }

    public final boolean isActive() {
        return !((Collection)this.systems).isEmpty();
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        float deltaTime = this.timer.getDeltaTime();
        for (int i = this.systems.size() - 1; -1 < i; --i) {
            PartySystem partySystem = this.systems.get(i);
            long totalTimeRunning = this.timer.getTotalTimeRunning(partySystem.getCreatedAt());
            if (totalTimeRunning >= (long)partySystem.getParty().getDelay()) {
                Iterable $this$forEach$iv = partySystem.render(deltaTime, this.drawArea);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Particle it = (Particle)element$iv;
                    boolean bl = false;
                    this.display(it, canvas);
                }
            }
            if (!partySystem.isDoneEmitting()) continue;
            this.systems.remove(i);
            OnParticleSystemUpdateListener onParticleSystemUpdateListener = this.onParticleSystemUpdateListener;
            if (onParticleSystemUpdateListener == null) continue;
            onParticleSystemUpdateListener.onParticleSystemEnded(this, partySystem.getParty(), this.systems.size());
        }
        if (this.systems.size() != 0) {
            this.invalidate();
        } else {
            this.timer.reset();
        }
    }

    private final void display(Particle $this$display, Canvas canvas) {
        this.paint.setColor($this$display.getColor());
        float centerX = $this$display.getScaleX() * $this$display.getWidth() / (float)2;
        int saveCount = canvas.save();
        canvas.translate($this$display.getX() - centerX, $this$display.getY());
        canvas.rotate($this$display.getRotation(), centerX, $this$display.getWidth() / (float)2);
        canvas.scale($this$display.getScaleX(), 1.0f);
        DrawShapesKt.draw($this$display.getShape(), canvas, this.paint, $this$display.getWidth());
        canvas.restoreToCount(saveCount);
    }

    /*
     * WARNING - void declaration
     */
    public final void start(Party ... party) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)party, (String)"party");
        Party[] partyArray = party;
        List<PartySystem> list = this.systems;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            OnParticleSystemUpdateListener onParticleSystemUpdateListener = this.onParticleSystemUpdateListener;
            if (onParticleSystemUpdateListener != null) {
                onParticleSystemUpdateListener.onParticleSystemStarted(this, (Party)it, this.systems.size());
            }
            collection.add(new PartySystem((Party)it, 0L, 0.0f, 6, null));
        }
        list.addAll((List)destination$iv$iv);
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void start(@NotNull List<Party> party) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(party, (String)"party");
        Iterable iterable = party;
        List<PartySystem> list = this.systems;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Party party2 = (Party)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            OnParticleSystemUpdateListener onParticleSystemUpdateListener = this.onParticleSystemUpdateListener;
            if (onParticleSystemUpdateListener != null) {
                onParticleSystemUpdateListener.onParticleSystemStarted(this, (Party)it, this.systems.size());
            }
            collection.add(new PartySystem((Party)it, 0L, 0.0f, 6, null));
        }
        list.addAll((List)destination$iv$iv);
        this.invalidate();
    }

    public final void start(@NotNull Party party) {
        Intrinsics.checkNotNullParameter((Object)party, (String)"party");
        this.systems.add(new PartySystem(party, 0L, 0.0f, 6, null));
        OnParticleSystemUpdateListener onParticleSystemUpdateListener = this.onParticleSystemUpdateListener;
        if (onParticleSystemUpdateListener != null) {
            onParticleSystemUpdateListener.onParticleSystemStarted(this, party, this.systems.size());
        }
        this.invalidate();
    }

    public final void stop(@NotNull Party party) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)party, (String)"party");
            CollectionsKt.removeAll(this.systems, (Function1)((Function1)new Function1<PartySystem, Boolean>(party){
                final /* synthetic */ Party $party;
                {
                    this.$party = $party;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull PartySystem it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getParty(), (Object)this.$party);
                }
            }));
            OnParticleSystemUpdateListener onParticleSystemUpdateListener = this.onParticleSystemUpdateListener;
            if (onParticleSystemUpdateListener == null) break block0;
            onParticleSystemUpdateListener.onParticleSystemEnded(this, party, this.systems.size());
        }
    }

    public final void reset() {
        this.systems.clear();
    }

    public final void stopGracefully() {
        Iterable $this$forEach$iv = this.systems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PartySystem it = (PartySystem)element$iv;
            boolean bl = false;
            it.setEnabled(false);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.drawArea = new Rect(0, 0, w, h);
    }

    protected void onVisibilityChanged(@NotNull View changedView, int visibility) {
        Intrinsics.checkNotNullParameter((Object)changedView, (String)"changedView");
        super.onVisibilityChanged(changedView, visibility);
        this.timer.reset();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lnl/dionsegijn/konfetti/xml/KonfettiView$TimerIntegration;", "", "()V", "previousTime", "", "getDeltaTime", "", "getTotalTimeRunning", "startTime", "reset", "", "xml_release"})
    public static final class TimerIntegration {
        private long previousTime = -1L;

        public final void reset() {
            this.previousTime = -1L;
        }

        public final float getDeltaTime() {
            if (this.previousTime == -1L) {
                this.previousTime = System.nanoTime();
            }
            long currentTime = System.nanoTime();
            float dt = (float)(currentTime - this.previousTime) / 1000000.0f;
            this.previousTime = currentTime;
            return dt / (float)1000;
        }

        public final long getTotalTimeRunning(long startTime) {
            long currentTime = System.currentTimeMillis();
            return currentTime - startTime;
        }
    }
}

