/*
 * Decompiled with CFR 0.152.
 */
package nl.dionsegijn.konfetti.xml;

import android.graphics.BlendMode;
import android.graphics.BlendModeColorFilter;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.os.Build;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nl.dionsegijn.konfetti.core.models.Shape;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"draw", "", "Lnl/dionsegijn/konfetti/core/models/Shape;", "canvas", "Landroid/graphics/Canvas;", "paint", "Landroid/graphics/Paint;", "size", "", "xml_release"})
public final class DrawShapesKt {
    public static final void draw(@NotNull Shape $this$draw, @NotNull Canvas canvas, @NotNull Paint paint, float size) {
        Intrinsics.checkNotNullParameter((Object)$this$draw, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        Shape shape = $this$draw;
        if (Intrinsics.areEqual((Object)shape, (Object)Shape.Square.INSTANCE)) {
            canvas.drawRect(0.0f, 0.0f, size, size, paint);
        } else if (Intrinsics.areEqual((Object)shape, (Object)Shape.Circle.INSTANCE)) {
            Shape.Circle.INSTANCE.getRect().set(0.0f, 0.0f, size, size);
            canvas.drawOval(Shape.Circle.INSTANCE.getRect(), paint);
        } else if (shape instanceof Shape.Rectangle) {
            float height = size * ((Shape.Rectangle)$this$draw).getHeightRatio();
            float top = (size - height) / 2.0f;
            canvas.drawRect(0.0f, top, size, top + height, paint);
        } else if (shape instanceof Shape.DrawableShape) {
            if (((Shape.DrawableShape)$this$draw).getTint()) {
                if (Build.VERSION.SDK_INT >= 29) {
                    ((Shape.DrawableShape)$this$draw).getDrawable().setColorFilter((ColorFilter)new BlendModeColorFilter(paint.getColor(), BlendMode.SRC_IN));
                } else {
                    ((Shape.DrawableShape)$this$draw).getDrawable().setColorFilter(paint.getColor(), PorterDuff.Mode.SRC_IN);
                }
            } else if (((Shape.DrawableShape)$this$draw).getApplyAlpha()) {
                ((Shape.DrawableShape)$this$draw).getDrawable().setAlpha(paint.getAlpha());
            }
            int height = (int)(size * ((Shape.DrawableShape)$this$draw).getHeightRatio());
            int top = (int)((size - (float)height) / 2.0f);
            ((Shape.DrawableShape)$this$draw).getDrawable().setBounds(0, top, (int)size, top + height);
            ((Shape.DrawableShape)$this$draw).getDrawable().draw(canvas);
        }
    }
}

