/*
 * Decompiled with CFR 0.152.
 */
package nl.codecentric.axon.openadmin.metrics;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import nl.codecentric.axon.openadmin.metrics.MicrometerMetricProvider;
import nl.codecentric.axon.openadmin.metrics.StatisticForSeconds;
import nl.codecentric.axon.openadmin.metrics.Statistics;
import nl.codecentric.axon.openadmin.model.ProcessorDTO;
import nl.codecentric.axon.openadmin.model.ProcessorId;
import nl.codecentric.axon.openadmin.model.ProcessorIdKt;
import nl.codecentric.axon.openadmin.model.SegmentDTO;
import nl.codecentric.axon.openadmin.model.TokenInformationDTO;
import nl.codecentric.axon.openadmin.tokens.TokenProvider;
import org.axonframework.eventhandling.ReplayToken;
import org.axonframework.eventhandling.Segment;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.tokenstore.AbstractTokenEntry;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.serialization.Serializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u00010B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ&\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J'\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u000e2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001f\u001a\u00020\u001aH\u0012\u00a2\u0006\u0002\u0010 J\u0016\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000b0$H\u0012J\u0012\u0010%\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001d\u001a\u00020\u000eH\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0017J\"\u0010*\u001a\u00020)2\u0010\u0010+\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030,0$2\u0006\u0010\u001f\u001a\u00020\u001aH\u0012J*\u0010-\u001a\u00020)2\u0010\u0010+\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030,0$2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u001f\u001a\u00020\u001aH\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00108\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00120\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lnl/codecentric/axon/openadmin/metrics/TokenStatusService;", "", "tokenProvider", "Lnl/codecentric/axon/openadmin/tokens/TokenProvider;", "serializer", "Lorg/axonframework/serialization/Serializer;", "eventStore", "Lorg/axonframework/eventsourcing/eventstore/EventStore;", "(Lnl/codecentric/axon/openadmin/tokens/TokenProvider;Lorg/axonframework/serialization/Serializer;Lorg/axonframework/eventsourcing/eventstore/EventStore;)V", "headMeasurements", "", "Lnl/codecentric/axon/openadmin/metrics/TokenStatusService$Measurement;", "metricMap", "", "Lnl/codecentric/axon/openadmin/model/ProcessorId;", "micrometerMetricProvider", "Lnl/codecentric/axon/openadmin/metrics/MicrometerMetricProvider;", "statisticMap", "Lnl/codecentric/axon/openadmin/metrics/Statistics;", "tokenInformationMap", "", "Lnl/codecentric/axon/openadmin/model/ProcessorDTO;", "calculateForTimeInSeconds", "Lnl/codecentric/axon/openadmin/metrics/StatisticForSeconds;", "measurements", "seconds", "", "behind", "computeStatistics", "id", "position", "headPosition", "(Lnl/codecentric/axon/openadmin/model/ProcessorId;Ljava/lang/Long;J)Lnl/codecentric/axon/openadmin/metrics/Statistics;", "getDiff", "", "values", "", "getStatistics", "getTokenInformation", "Lnl/codecentric/axon/openadmin/model/TokenInformationDTO;", "updateCachedInformation", "", "updateProcessorDtos", "processors", "Lorg/axonframework/eventhandling/tokenstore/AbstractTokenEntry;", "updateStatistics", "time", "Ljava/time/Instant;", "Measurement", "axon-open-admin-starter"})
public class TokenStatusService {
    @Autowired(required=false)
    private final MicrometerMetricProvider micrometerMetricProvider;
    private final Map<ProcessorId, List<Measurement>> metricMap;
    private final Map<ProcessorId, Statistics> statisticMap;
    private final Map<String, ProcessorDTO> tokenInformationMap;
    private final List<Measurement> headMeasurements;
    private final TokenProvider tokenProvider;
    private final Serializer serializer;
    private final EventStore eventStore;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public TokenInformationDTO getTokenInformation() {
        Object v0;
        void $this$maxByOrNull$iv;
        Iterable iterable = this.headMeasurements;
        String string = this.tokenProvider.getNodeId();
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                Measurement it = (Measurement)maxElem$iv;
                boolean bl = false;
                Comparable maxValue$iv = it.getTime();
                do {
                    Object e$iv = iterator$iv.next();
                    Measurement it2 = (Measurement)e$iv;
                    $i$a$-maxByOrNull-TokenStatusService$getTokenInformation$1 = false;
                    Comparable v$iv = it2.getTime();
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        Object var12_12 = v0;
        Measurement measurement = var12_12;
        Long l = measurement != null ? Long.valueOf(measurement.getValue()) : null;
        Intrinsics.checkNotNull((Object)l);
        Iterable $this$sortedBy$iv = CollectionsKt.toList((Iterable)this.tokenInformationMap.values());
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        List list = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                ProcessorDTO it = (ProcessorDTO)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (ProcessorDTO)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        });
        long l2 = l;
        String string2 = string;
        return new TokenInformationDTO(string2, l2, list);
    }

    @Scheduled(fixedRate=2000L, initialDelay=1000L)
    public void updateCachedInformation() {
        Instant time = Instant.now();
        TrackingToken headToken = this.eventStore.createHeadToken();
        Object object = headToken;
        long headPosition = object != null && (object = object.position()) != null ? ((OptionalLong)object).orElse(0L) : 0L;
        Instant instant = time;
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"time");
        this.headMeasurements.add(new Measurement(instant, headPosition));
        this.headMeasurements.removeIf(new Predicate<Measurement>(time){
            final /* synthetic */ Instant $time;

            public final boolean test(@NotNull Measurement m) {
                Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                return m.getTime().isBefore(this.$time.minus(5L, ChronoUnit.MINUTES));
            }
            {
                this.$time = instant;
            }
        });
        List<AbstractTokenEntry<?>> processors = this.tokenProvider.getProcessors();
        this.updateStatistics(processors, time, headPosition);
        this.updateProcessorDtos(processors, headPosition);
    }

    /*
     * WARNING - void declaration
     */
    private void updateProcessorDtos(List<? extends AbstractTokenEntry<?>> processors, long headPosition) {
        void $this$forEach$iv;
        Iterable answer$iv$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv = processors;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            AbstractTokenEntry it = (AbstractTokenEntry)element$iv$iv;
            boolean bl5 = false;
            String key$iv$iv = it.getProcessorName();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        iterable = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = iterable.entrySet().iterator();
        while (iterator.hasNext()) {
            List list;
            Object v11;
            void $this$minByOrNull$iv;
            Collection<Long> collection;
            boolean bl3;
            Iterable $this$any$iv;
            void var53_70;
            List list2;
            List segmentDtos;
            SegmentDTO segmentDTO;
            SegmentDTO it;
            Object object;
            Iterable $this$mapTo$iv$iv3;
            boolean $i$f$mapTo;
            Collection destination$iv$iv2;
            boolean $i$f$map;
            Iterable $this$map$iv;
            block18: {
                void processorName;
                Iterable $this$sortedBy$iv;
                Map.Entry element$iv;
                Map.Entry $dstr$processorName$segments = element$iv = iterator.next();
                boolean bl4 = false;
                Map.Entry bl5 = $dstr$processorName$segments;
                boolean key$iv$iv = false;
                $this$getOrPut$iv$iv$iv = (String)bl5.getKey();
                bl5 = $dstr$processorName$segments;
                key$iv$iv = false;
                List segments = (List)bl5.getValue();
                $this$map$iv = segments;
                $i$f$map = false;
                answer$iv$iv$iv = $this$map$iv;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                    String string;
                    void $this$toTypedArray$iv;
                    Number number;
                    Collection<Integer> collection2;
                    Object object2;
                    void $this$mapTo$iv$iv2;
                    Collection $this$map$iv2;
                    AbstractTokenEntry abstractTokenEntry = (AbstractTokenEntry)item$iv$iv;
                    object = destination$iv$iv2;
                    boolean bl6 = false;
                    TrackingToken token = it.getToken(this.serializer);
                    Object object3 = token;
                    long currentIndex = object3 != null && (object3 = object3.position()) != null ? ((OptionalLong)object3).orElse(0L) : 0L;
                    long behind = headPosition - currentIndex;
                    String string2 = it.getProcessorName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.processorName");
                    Statistics statistics = this.statisticMap.get(new ProcessorId(string2, it.getSegment()));
                    Object object4 = segments;
                    int n = it.getSegment();
                    boolean $i$f$map2 = false;
                    Double d = $this$map$iv2;
                    Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                        void s;
                        object2 = (AbstractTokenEntry)item$iv$iv2;
                        collection2 = destination$iv$iv3;
                        boolean bl7 = false;
                        number = s.getSegment();
                        collection2.add((Integer)number);
                    }
                    collection2 = (List)destination$iv$iv3;
                    $this$map$iv2 = collection2;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    Integer[] integerArray = thisCollection$iv.toArray(new Integer[0]);
                    if (integerArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    int[] nArray = ArraysKt.toIntArray((Integer[])integerArray);
                    Segment computedSegment = Segment.computeSegment((int)n, (int[])Arrays.copyOf(nArray, nArray.length));
                    Number number2 = currentIndex;
                    TrackingToken trackingToken = token;
                    if (trackingToken != null) {
                        void t;
                        object4 = trackingToken;
                        boolean bl8 = false;
                        boolean bl9 = false;
                        destination$iv$iv3 = object4;
                        number = number2;
                        boolean bl10 = false;
                        String string3 = t.getClass().getSimpleName();
                        number2 = number;
                        string = string3;
                    } else {
                        string = null;
                    }
                    object4 = computedSegment.splitSegmentId();
                    Integer n2 = computedSegment.mergeableSegmentId();
                    Object object5 = statistics;
                    d = object5 != null && (object5 = ((Statistics)object5).getSeconds10()) != null && (object5 = ((StatisticForSeconds)object5).getMinutesToHead()) != null ? Double.valueOf((Double)object5 * (double)60) : null;
                    Statistics statistics2 = statistics;
                    long l = behind;
                    Boolean bl11 = ReplayToken.isReplay((TrackingToken)token);
                    object2 = it.getSegment();
                    String string4 = it.getOwner();
                    String string5 = string;
                    Number number3 = number2;
                    Object object6 = object4;
                    Integer n3 = n2;
                    Double d2 = d;
                    Statistics statistics3 = statistics2;
                    long l2 = l;
                    Boolean bl12 = bl11;
                    Number number4 = number3;
                    String string6 = string4;
                    String string7 = string5;
                    Object object7 = object2;
                    segmentDTO = new SegmentDTO((Integer)object7, string7, string6, (Long)number4, bl12, l2, statistics3, d2, n3, (Integer)object6);
                    object.add(segmentDTO);
                }
                $this$map$iv = (List)destination$iv$iv2;
                boolean $i$f$sortedBy = false;
                boolean $this$mapTo$iv$iv3 = false;
                segmentDtos = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        SegmentDTO it = (SegmentDTO)a;
                        boolean bl2 = false;
                        Comparable comparable = it.getSegment();
                        it = (SegmentDTO)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Integer n = it.getSegment();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                    }
                });
                void v9 = processorName;
                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"processorName");
                $this$sortedBy$iv = segmentDtos;
                list2 = segmentDtos;
                var53_70 = processorName;
                segmentDTO = v9;
                object = this.tokenInformationMap;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        SegmentDTO it2 = (SegmentDTO)element$iv2;
                        boolean bl13 = false;
                        if (!Intrinsics.areEqual((Object)it2.getReplaying(), (Object)true)) continue;
                        bl3 = true;
                        break block18;
                    }
                    bl3 = false;
                }
            }
            boolean bl14 = bl3;
            $this$any$iv = segmentDtos;
            Boolean bl15 = bl14;
            $i$f$map = false;
            $this$mapTo$iv$iv3 = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                it = (SegmentDTO)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl16 = false;
                Long l = it.getCurrentIndex();
                collection.add(l);
            }
            collection = (List)destination$iv$iv2;
            $this$map$iv = collection;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v11 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v11 = minElem$iv;
                } else {
                    Long it3 = (Long)minElem$iv;
                    boolean bl17 = false;
                    Long l = it3;
                    long minValue$iv = l != null ? l : 0L;
                    do {
                        long v$iv;
                        Object e$iv = iterator$iv.next();
                        Long it4 = (Long)e$iv;
                        $i$a$-minByOrNull-TokenStatusService$updateProcessorDtos$2$3 = false;
                        Long l3 = it4;
                        long l4 = v$iv = l3 != null ? l3 : 0L;
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v11 = minElem$iv;
                }
            }
            collection = v11;
            Long l = (Long)((Object)collection);
            Boolean bl18 = bl15;
            List list3 = list = list2;
            Boolean bl19 = bl18;
            Long l5 = l;
            void var73_88 = var53_70;
            object.put(segmentDTO, new ProcessorDTO((String)var73_88, l5, bl19, list3));
        }
    }

    private void updateStatistics(List<? extends AbstractTokenEntry<?>> processors, Instant time, long headPosition) {
        Iterable $this$forEach$iv = processors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List<Measurement> metricList;
            long lastKnownPosition;
            long l;
            long position;
            AbstractTokenEntry it = (AbstractTokenEntry)element$iv;
            boolean bl = false;
            TrackingToken token = it.getToken(this.serializer);
            ProcessorId id = ProcessorIdKt.toId(it);
            Object object = token;
            long l2 = object != null && (object = object.position()) != null ? ((OptionalLong)object).orElse(0L) : (position = 0L);
            if (this.metricMap.get(id) != null) {
                Object v2;
                List<Measurement> list;
                boolean bl2 = false;
                boolean bl3 = false;
                List<Measurement> mm = list;
                boolean bl4 = false;
                Iterable $this$maxByOrNull$iv = mm;
                boolean $i$f$maxByOrNull = false;
                Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v2 = null;
                } else {
                    Object maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v2 = maxElem$iv;
                    } else {
                        Measurement mv = (Measurement)maxElem$iv;
                        boolean bl5 = false;
                        long maxValue$iv = mv.getValue();
                        do {
                            Object e$iv = iterator$iv.next();
                            Measurement mv2 = (Measurement)e$iv;
                            $i$a$-maxByOrNull-TokenStatusService$updateStatistics$1$lastKnownPosition$1$1 = false;
                            long v$iv = mv2.getValue();
                            if (maxValue$iv >= v$iv) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v2 = maxElem$iv;
                    }
                }
                Measurement measurement = v2;
                l = measurement != null ? measurement.getValue() : 0L;
            } else {
                l = lastKnownPosition = 0L;
            }
            if (it.getOwner() == null || position < lastKnownPosition) {
                this.metricMap.remove(id);
            }
            Intrinsics.checkNotNullExpressionValue(this.metricMap.computeIfAbsent(id, new Function<ProcessorId, List<Measurement>>(it, this, time, headPosition){
                final /* synthetic */ AbstractTokenEntry $it;
                final /* synthetic */ TokenStatusService this$0;
                final /* synthetic */ Instant $time$inlined;
                final /* synthetic */ long $headPosition$inlined;
                {
                    this.$it = abstractTokenEntry;
                    this.this$0 = tokenStatusService;
                    this.$time$inlined = instant;
                    this.$headPosition$inlined = l;
                }

                @NotNull
                public final List<Measurement> apply(@NotNull ProcessorId processorId) {
                    Intrinsics.checkNotNullParameter((Object)processorId, (String)"processorId");
                    MicrometerMetricProvider micrometerMetricProvider = TokenStatusService.access$getMicrometerMetricProvider$p(this.this$0);
                    if (micrometerMetricProvider != null) {
                        micrometerMetricProvider.registerTokenAsGauge(this.$it, processorId);
                    }
                    boolean bl = false;
                    return new ArrayList<E>();
                }
            }), (String)"metricMap.computeIfAbsen\u2026bleListOf()\n            }");
            metricList.add(new Measurement(time, position));
            metricList.removeIf(new Predicate<Measurement>(this, time, headPosition){
                final /* synthetic */ TokenStatusService this$0;
                final /* synthetic */ Instant $time$inlined;
                final /* synthetic */ long $headPosition$inlined;
                {
                    this.this$0 = tokenStatusService;
                    this.$time$inlined = instant;
                    this.$headPosition$inlined = l;
                }

                public final boolean test(@NotNull Measurement m) {
                    Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                    return m.getTime().isBefore(this.$time$inlined.minus(5L, ChronoUnit.MINUTES));
                }
            });
            this.statisticMap.put(id, this.computeStatistics(id, position, headPosition));
        }
    }

    @Nullable
    public Statistics getStatistics(@NotNull ProcessorId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.statisticMap.get(id);
    }

    private Statistics computeStatistics(ProcessorId id, Long position, long headPosition) {
        List<Measurement> list = this.metricMap.get(id);
        Intrinsics.checkNotNull(list);
        List<Measurement> values = list;
        Long l = position;
        long behind = headPosition - (l != null ? l : 0L);
        return new Statistics(behind, this.calculateForTimeInSeconds(values, 10L, behind), this.calculateForTimeInSeconds(values, 60L, behind), this.calculateForTimeInSeconds(values, 300L, behind));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public StatisticForSeconds calculateForTimeInSeconds(@NotNull List<Measurement> measurements, long seconds, long behind) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable $this$filterTo$iv$iv2;
        void $this$filter$iv2;
        Intrinsics.checkNotNullParameter(measurements, (String)"measurements");
        Instant time = Instant.now();
        Iterable iterable = measurements;
        TokenStatusService tokenStatusService = this;
        boolean $i$f$filter = false;
        void var11_9 = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            Measurement it = (Measurement)element$iv$iv;
            boolean bl = false;
            if (!it.getTime().isAfter(time.minus(seconds, ChronoUnit.SECONDS))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        double positionRate = tokenStatusService.getDiff(list);
        $this$filterTo$iv$iv2 = this.headMeasurements;
        tokenStatusService = this;
        boolean $i$f$filter2 = false;
        void $i$f$filterTo22 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Measurement it = (Measurement)element$iv$iv;
            boolean bl = false;
            if (!it.getTime().isAfter(time.minus(seconds, ChronoUnit.SECONDS))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        list = (List)destination$iv$iv2;
        double ingestRate = tokenStatusService.getDiff(list);
        double effectiveRate = MathKt.truncate((double)((positionRate - ingestRate) * (double)100)) / (double)100;
        return new StatisticForSeconds(seconds, ingestRate, positionRate, effectiveRate, behind > 0L && effectiveRate > 0.0 ? Double.valueOf((double)behind / effectiveRate) : null);
    }

    private double getDiff(List<Measurement> values) {
        double value;
        Object v2;
        Object v0;
        Iterable $this$maxByOrNull$iv = values;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                Measurement it = (Measurement)maxElem$iv;
                boolean bl = false;
                Comparable maxValue$iv = it.getTime();
                do {
                    Object e$iv = iterator$iv.next();
                    Measurement it2 = (Measurement)e$iv;
                    $i$a$-maxByOrNull-TokenStatusService$getDiff$last$1 = false;
                    Comparable v$iv = it2.getTime();
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        Measurement measurement = v0;
        if (measurement == null) {
            return 0.0;
        }
        Measurement last = measurement;
        Iterable $this$minByOrNull$iv = values;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv2 = $this$minByOrNull$iv.iterator();
        if (!iterator$iv2.hasNext()) {
            v2 = null;
        } else {
            Object minElem$iv = iterator$iv2.next();
            if (!iterator$iv2.hasNext()) {
                v2 = minElem$iv;
            } else {
                Measurement it = (Measurement)minElem$iv;
                boolean bl = false;
                Comparable minValue$iv = it.getTime();
                do {
                    Object e$iv = iterator$iv2.next();
                    Measurement it3 = (Measurement)e$iv;
                    $i$a$-minByOrNull-TokenStatusService$getDiff$first$1 = false;
                    Comparable v$iv = it3.getTime();
                    if (minValue$iv.compareTo(v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv2.hasNext());
                v2 = minElem$iv;
            }
        }
        Measurement measurement2 = v2;
        if (measurement2 == null) {
            return 0.0;
        }
        Measurement first = measurement2;
        long lastValue = last.getValue();
        long firstValue = first.getValue();
        double d = value = lastValue < firstValue ? (double)firstValue / (double)ChronoUnit.SECONDS.between(first.getTime(), last.getTime()) : (double)(lastValue - firstValue) / (double)ChronoUnit.SECONDS.between(first.getTime(), last.getTime());
        boolean bl = false;
        if (Double.isNaN(d)) {
            return 0.0;
        }
        return value * (double)60;
    }

    public TokenStatusService(@NotNull TokenProvider tokenProvider, @NotNull Serializer serializer, @NotNull EventStore eventStore) {
        Intrinsics.checkNotNullParameter((Object)tokenProvider, (String)"tokenProvider");
        Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        this.tokenProvider = tokenProvider;
        this.serializer = serializer;
        this.eventStore = eventStore;
        boolean bl = false;
        this.metricMap = new LinkedHashMap();
        bl = false;
        this.statisticMap = new LinkedHashMap();
        bl = false;
        this.tokenInformationMap = new LinkedHashMap();
        bl = false;
        this.headMeasurements = new ArrayList();
    }

    public static final /* synthetic */ MicrometerMetricProvider access$getMicrometerMetricProvider$p(TokenStatusService $this) {
        return $this.micrometerMetricProvider;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lnl/codecentric/axon/openadmin/metrics/TokenStatusService$Measurement;", "", "time", "Ljava/time/Instant;", "value", "", "(Ljava/time/Instant;J)V", "getTime", "()Ljava/time/Instant;", "getValue", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "axon-open-admin-starter"})
    public static final class Measurement {
        @NotNull
        private final Instant time;
        private final long value;

        @NotNull
        public final Instant getTime() {
            return this.time;
        }

        public final long getValue() {
            return this.value;
        }

        public Measurement(@NotNull Instant time, long value) {
            Intrinsics.checkNotNullParameter((Object)time, (String)"time");
            this.time = time;
            this.value = value;
        }

        @NotNull
        public final Instant component1() {
            return this.time;
        }

        public final long component2() {
            return this.value;
        }

        @NotNull
        public final Measurement copy(@NotNull Instant time, long value) {
            Intrinsics.checkNotNullParameter((Object)time, (String)"time");
            return new Measurement(time, value);
        }

        public static /* synthetic */ Measurement copy$default(Measurement measurement, Instant instant, long l, int n, Object object) {
            if ((n & 1) != 0) {
                instant = measurement.time;
            }
            if ((n & 2) != 0) {
                l = measurement.value;
            }
            return measurement.copy(instant, l);
        }

        @NotNull
        public String toString() {
            return "Measurement(time=" + this.time + ", value=" + this.value + ")";
        }

        public int hashCode() {
            Instant instant = this.time;
            return (instant != null ? ((Object)instant).hashCode() : 0) * 31 + Long.hashCode(this.value);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Measurement)) break block3;
                    Measurement measurement = (Measurement)object;
                    if (!Intrinsics.areEqual((Object)this.time, (Object)measurement.time) || this.value != measurement.value) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

