/*
 * Decompiled with CFR 0.152.
 */
package com.insidion.axon.openadmin.metrics;

import com.insidion.axon.openadmin.metrics.MicrometerMetricProvider;
import com.insidion.axon.openadmin.metrics.StatisticForSeconds;
import com.insidion.axon.openadmin.metrics.Statistics;
import com.insidion.axon.openadmin.model.ProcessorId;
import com.insidion.axon.openadmin.model.ProcessorIdKt;
import com.insidion.axon.openadmin.tokens.TokenProvider;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.tokenstore.AbstractTokenEntry;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.serialization.Serializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001%B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ&\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J'\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u000e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001c\u001a\u00020\u0017H\u0012\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0!H\u0012J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001a\u001a\u00020\u000eH\u0016J\b\u0010#\u001a\u00020$H\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00108\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00120\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/insidion/axon/openadmin/metrics/ProcessorMetricsService;", "", "tokenProvider", "Lcom/insidion/axon/openadmin/tokens/TokenProvider;", "serializer", "Lorg/axonframework/serialization/Serializer;", "eventStore", "Lorg/axonframework/eventsourcing/eventstore/EventStore;", "(Lcom/insidion/axon/openadmin/tokens/TokenProvider;Lorg/axonframework/serialization/Serializer;Lorg/axonframework/eventsourcing/eventstore/EventStore;)V", "headMeasurements", "", "Lcom/insidion/axon/openadmin/metrics/ProcessorMetricsService$Measurement;", "metricMap", "", "Lcom/insidion/axon/openadmin/model/ProcessorId;", "micrometerMetricProvider", "Lcom/insidion/axon/openadmin/metrics/MicrometerMetricProvider;", "statisticMap", "Lcom/insidion/axon/openadmin/metrics/Statistics;", "calculateForTimeInSeconds", "Lcom/insidion/axon/openadmin/metrics/StatisticForSeconds;", "measurements", "seconds", "", "behind", "computeStatistics", "id", "position", "headPosition", "(Lcom/insidion/axon/openadmin/model/ProcessorId;Ljava/lang/Long;J)Lcom/insidion/axon/openadmin/metrics/Statistics;", "getDiff", "", "values", "", "getStatistics", "updateMetrics", "", "Measurement", "axon-open-admin-starter"})
public class ProcessorMetricsService {
    @Autowired(required=false)
    private final MicrometerMetricProvider micrometerMetricProvider;
    private final Map<ProcessorId, List<Measurement>> metricMap;
    private final Map<ProcessorId, Statistics> statisticMap;
    private final List<Measurement> headMeasurements;
    private final TokenProvider tokenProvider;
    private final Serializer serializer;
    private final EventStore eventStore;

    /*
     * WARNING - void declaration
     */
    @Scheduled(fixedRate=2000L, initialDelay=1000L)
    public void updateMetrics() {
        void $this$mapTo$iv$iv;
        Instant time = Instant.now();
        TrackingToken headToken = this.eventStore.createHeadToken();
        Object object = headToken;
        long headPosition = object != null && (object = object.position()) != null ? ((OptionalLong)object).orElse(0L) : 0L;
        Instant instant = time;
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"time");
        this.headMeasurements.add(new Measurement(instant, headPosition));
        this.headMeasurements.removeIf(new Predicate<Measurement>(time){
            final /* synthetic */ Instant $time;

            public final boolean test(@NotNull Measurement m) {
                Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                return m.getTime().isBefore(this.$time.minus(5L, ChronoUnit.MINUTES));
            }
            {
                this.$time = instant;
            }
        });
        Iterable $this$map$iv = this.tokenProvider.getProcessors();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            List<Measurement> metricList;
            long lastKnownPosition;
            long l;
            long position;
            void it;
            AbstractTokenEntry abstractTokenEntry = (AbstractTokenEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TrackingToken token = it.getToken(this.serializer);
            ProcessorId id = ProcessorIdKt.toId(it);
            Object object2 = token;
            long l2 = object2 != null && (object2 = object2.position()) != null ? ((OptionalLong)object2).orElse(0L) : (position = 0L);
            if (this.metricMap.get(id) != null) {
                Object v4;
                List<Measurement> list;
                boolean bl2 = false;
                boolean bl3 = false;
                List<Measurement> mm = list;
                boolean bl4 = false;
                Iterable $this$maxByOrNull$iv = mm;
                boolean $i$f$maxByOrNull = false;
                Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v4 = null;
                } else {
                    Object maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v4 = maxElem$iv;
                    } else {
                        Measurement mv = (Measurement)maxElem$iv;
                        boolean bl5 = false;
                        long maxValue$iv = mv.getValue();
                        do {
                            Object e$iv = iterator$iv.next();
                            Measurement mv2 = (Measurement)e$iv;
                            $i$a$-maxByOrNull-ProcessorMetricsService$updateMetrics$2$lastKnownPosition$1$1 = false;
                            long v$iv = mv2.getValue();
                            if (maxValue$iv >= v$iv) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v4 = maxElem$iv;
                    }
                }
                Measurement measurement = v4;
                l = measurement != null ? measurement.getValue() : 0L;
            } else {
                l = lastKnownPosition = 0L;
            }
            if (it.getOwner() == null || position < lastKnownPosition) {
                this.metricMap.remove(id);
            }
            Intrinsics.checkNotNullExpressionValue(this.metricMap.computeIfAbsent(id, new Function<ProcessorId, List<Measurement>>((AbstractTokenEntry)it, this, time, headPosition){
                final /* synthetic */ AbstractTokenEntry $it;
                final /* synthetic */ ProcessorMetricsService this$0;
                final /* synthetic */ Instant $time$inlined;
                final /* synthetic */ long $headPosition$inlined;
                {
                    this.$it = abstractTokenEntry;
                    this.this$0 = processorMetricsService;
                    this.$time$inlined = instant;
                    this.$headPosition$inlined = l;
                }

                @NotNull
                public final List<Measurement> apply(@NotNull ProcessorId processorId) {
                    Intrinsics.checkNotNullParameter((Object)processorId, (String)"processorId");
                    MicrometerMetricProvider micrometerMetricProvider = ProcessorMetricsService.access$getMicrometerMetricProvider$p(this.this$0);
                    if (micrometerMetricProvider != null) {
                        micrometerMetricProvider.registerTokenAsGauge(this.$it, processorId);
                    }
                    boolean bl = false;
                    return new ArrayList<E>();
                }
            }), (String)"metricMap.computeIfAbsen\u2026bleListOf()\n            }");
            metricList.add(new Measurement(time, position));
            metricList.removeIf(new Predicate<Measurement>(this, time, headPosition){
                final /* synthetic */ ProcessorMetricsService this$0;
                final /* synthetic */ Instant $time$inlined;
                final /* synthetic */ long $headPosition$inlined;
                {
                    this.this$0 = processorMetricsService;
                    this.$time$inlined = instant;
                    this.$headPosition$inlined = l;
                }

                public final boolean test(@NotNull Measurement m) {
                    Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                    return m.getTime().isBefore(this.$time$inlined.minus(5L, ChronoUnit.MINUTES));
                }
            });
            this.statisticMap.put(id, this.computeStatistics(id, position, headPosition));
            Unit unit = Unit.INSTANCE;
            collection.add(unit);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    @Nullable
    public Statistics getStatistics(@NotNull ProcessorId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.statisticMap.get(id);
    }

    private Statistics computeStatistics(ProcessorId id, Long position, long headPosition) {
        List<Measurement> list = this.metricMap.get(id);
        Intrinsics.checkNotNull(list);
        List<Measurement> values = list;
        Long l = position;
        long behind = headPosition - (l != null ? l : 0L);
        return new Statistics(behind, this.calculateForTimeInSeconds(values, 10L, behind), this.calculateForTimeInSeconds(values, 60L, behind), this.calculateForTimeInSeconds(values, 300L, behind));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public StatisticForSeconds calculateForTimeInSeconds(@NotNull List<Measurement> measurements, long seconds, long behind) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable $this$filterTo$iv$iv2;
        void $this$filter$iv2;
        Intrinsics.checkNotNullParameter(measurements, (String)"measurements");
        Instant time = Instant.now();
        Iterable iterable = measurements;
        ProcessorMetricsService processorMetricsService = this;
        boolean $i$f$filter = false;
        void var11_9 = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            Measurement it = (Measurement)element$iv$iv;
            boolean bl = false;
            if (!it.getTime().isAfter(time.minus(seconds, ChronoUnit.SECONDS))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        double positionRate = processorMetricsService.getDiff(list);
        $this$filterTo$iv$iv2 = this.headMeasurements;
        processorMetricsService = this;
        boolean $i$f$filter2 = false;
        void $i$f$filterTo22 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Measurement it = (Measurement)element$iv$iv;
            boolean bl = false;
            if (!it.getTime().isAfter(time.minus(seconds, ChronoUnit.SECONDS))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        list = (List)destination$iv$iv2;
        double ingestRate = processorMetricsService.getDiff(list);
        double effectiveRate = MathKt.truncate((double)((positionRate - ingestRate) * (double)100)) / (double)100;
        return new StatisticForSeconds(seconds, ingestRate, positionRate, effectiveRate, behind > 0L && effectiveRate > 0.0 ? Double.valueOf((double)behind / effectiveRate) : null);
    }

    private double getDiff(List<Measurement> values) {
        double value;
        Object v2;
        Object v0;
        Iterable $this$maxByOrNull$iv = values;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                Measurement it = (Measurement)maxElem$iv;
                boolean bl = false;
                Comparable maxValue$iv = it.getTime();
                do {
                    Object e$iv = iterator$iv.next();
                    Measurement it2 = (Measurement)e$iv;
                    $i$a$-maxByOrNull-ProcessorMetricsService$getDiff$last$1 = false;
                    Comparable v$iv = it2.getTime();
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        Measurement measurement = v0;
        if (measurement == null) {
            return 0.0;
        }
        Measurement last = measurement;
        Iterable $this$minByOrNull$iv = values;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv2 = $this$minByOrNull$iv.iterator();
        if (!iterator$iv2.hasNext()) {
            v2 = null;
        } else {
            Object minElem$iv = iterator$iv2.next();
            if (!iterator$iv2.hasNext()) {
                v2 = minElem$iv;
            } else {
                Measurement it = (Measurement)minElem$iv;
                boolean bl = false;
                Comparable minValue$iv = it.getTime();
                do {
                    Object e$iv = iterator$iv2.next();
                    Measurement it3 = (Measurement)e$iv;
                    $i$a$-minByOrNull-ProcessorMetricsService$getDiff$first$1 = false;
                    Comparable v$iv = it3.getTime();
                    if (minValue$iv.compareTo(v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv2.hasNext());
                v2 = minElem$iv;
            }
        }
        Measurement measurement2 = v2;
        if (measurement2 == null) {
            return 0.0;
        }
        Measurement first = measurement2;
        long lastValue = last.getValue();
        long firstValue = first.getValue();
        double d = value = lastValue < firstValue ? (double)firstValue / (double)ChronoUnit.SECONDS.between(first.getTime(), last.getTime()) : (double)(lastValue - firstValue) / (double)ChronoUnit.SECONDS.between(first.getTime(), last.getTime());
        boolean bl = false;
        if (Double.isNaN(d)) {
            return 0.0;
        }
        return value * (double)60;
    }

    public ProcessorMetricsService(@NotNull TokenProvider tokenProvider, @NotNull Serializer serializer, @NotNull EventStore eventStore) {
        Intrinsics.checkNotNullParameter((Object)tokenProvider, (String)"tokenProvider");
        Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        this.tokenProvider = tokenProvider;
        this.serializer = serializer;
        this.eventStore = eventStore;
        boolean bl = false;
        this.metricMap = new LinkedHashMap();
        bl = false;
        this.statisticMap = new LinkedHashMap();
        bl = false;
        this.headMeasurements = new ArrayList();
    }

    public static final /* synthetic */ MicrometerMetricProvider access$getMicrometerMetricProvider$p(ProcessorMetricsService $this) {
        return $this.micrometerMetricProvider;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/insidion/axon/openadmin/metrics/ProcessorMetricsService$Measurement;", "", "time", "Ljava/time/Instant;", "value", "", "(Ljava/time/Instant;J)V", "getTime", "()Ljava/time/Instant;", "getValue", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "axon-open-admin-starter"})
    public static final class Measurement {
        @NotNull
        private final Instant time;
        private final long value;

        @NotNull
        public final Instant getTime() {
            return this.time;
        }

        public final long getValue() {
            return this.value;
        }

        public Measurement(@NotNull Instant time, long value) {
            Intrinsics.checkNotNullParameter((Object)time, (String)"time");
            this.time = time;
            this.value = value;
        }

        @NotNull
        public final Instant component1() {
            return this.time;
        }

        public final long component2() {
            return this.value;
        }

        @NotNull
        public final Measurement copy(@NotNull Instant time, long value) {
            Intrinsics.checkNotNullParameter((Object)time, (String)"time");
            return new Measurement(time, value);
        }

        public static /* synthetic */ Measurement copy$default(Measurement measurement, Instant instant, long l, int n, Object object) {
            if ((n & 1) != 0) {
                instant = measurement.time;
            }
            if ((n & 2) != 0) {
                l = measurement.value;
            }
            return measurement.copy(instant, l);
        }

        @NotNull
        public String toString() {
            return "Measurement(time=" + this.time + ", value=" + this.value + ")";
        }

        public int hashCode() {
            Instant instant = this.time;
            return (instant != null ? ((Object)instant).hashCode() : 0) * 31 + Long.hashCode(this.value);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Measurement)) break block3;
                    Measurement measurement = (Measurement)object;
                    if (!Intrinsics.areEqual((Object)this.time, (Object)measurement.time) || this.value != measurement.value) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

