/*
 * Decompiled with CFR 0.152.
 */
package com.insidion.axon.openadmin;

import com.insidion.axon.openadmin.AxonOpenAdminEndpoint;
import com.insidion.axon.openadmin.AxonOpenAdminEndpoint$sam$java_util_function_Function$0;
import com.insidion.axon.openadmin.events.EventTailingService;
import com.insidion.axon.openadmin.model.TokenInformationDTO;
import com.insidion.axon.openadmin.processors.ProcessorStatusService;
import com.insidion.axon.openadmin.tokens.TokenInformationService;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.axonframework.config.EventProcessingModule;
import org.axonframework.eventhandling.EventTrackerStatus;
import org.axonframework.eventhandling.StreamingEventProcessor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${axon.admin.base-url:axon-admin}"})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0017J\b\u0010\u0011\u001a\u00020\u0012H\u0017J\b\u0010\u0013\u001a\u00020\u0014H\u0017J\"\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u001bH\u0017J\"\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u001bH\u0017J\u0018\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\b\u0001\u0010\u0018\u001a\u00020\u0019H\u0017J*\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 H\u0012J\"\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u001bH\u0017J\u0018\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\b\u0001\u0010\u0018\u001a\u00020\u0019H\u0017J\u0018\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\b\u0001\u0010\u0018\u001a\u00020\u0019H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/insidion/axon/openadmin/AxonOpenAdminEndpoint;", "", "axonOpenAdminTokenStore", "Lcom/insidion/axon/openadmin/tokens/TokenInformationService;", "processorStatusService", "Lcom/insidion/axon/openadmin/processors/ProcessorStatusService;", "eventProcessingModule", "Lorg/axonframework/config/EventProcessingModule;", "eventTailingService", "Lcom/insidion/axon/openadmin/events/EventTailingService;", "(Lcom/insidion/axon/openadmin/tokens/TokenInformationService;Lcom/insidion/axon/openadmin/processors/ProcessorStatusService;Lorg/axonframework/config/EventProcessingModule;Lcom/insidion/axon/openadmin/events/EventTailingService;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getEvents", "", "Lcom/insidion/axon/openadmin/events/EventTailingService$CaughtEvent;", "getProcessors", "Lcom/insidion/axon/openadmin/processors/ProcessorStatusService$EventProcessorStatusDTO;", "getTokens", "Lcom/insidion/axon/openadmin/model/TokenInformationDTO;", "merge", "Lorg/springframework/http/ResponseEntity;", "", "processorName", "", "segmentId", "", "release", "reset", "runOnProcessorWithResponse", "block", "Lkotlin/Function1;", "Lorg/axonframework/eventhandling/StreamingEventProcessor;", "", "split", "start", "stop", "axon-open-admin-starter"})
public class AxonOpenAdminEndpoint {
    private final Logger logger;
    private final TokenInformationService axonOpenAdminTokenStore;
    private final ProcessorStatusService processorStatusService;
    private final EventProcessingModule eventProcessingModule;
    private final EventTailingService eventTailingService;

    @GetMapping(value={"/tokens"})
    @NotNull
    public TokenInformationDTO getTokens() {
        return this.axonOpenAdminTokenStore.getProcessors();
    }

    @GetMapping(value={"/processors"})
    @NotNull
    public ProcessorStatusService.EventProcessorStatusDTO getProcessors() {
        return this.processorStatusService.getStatus();
    }

    @GetMapping(value={"/events"})
    @NotNull
    public List<EventTailingService.CaughtEvent> getEvents() {
        return this.eventTailingService.getEvents();
    }

    @PostMapping(value={"/processor/{processorName}/split/{segmentId}"})
    @NotNull
    public ResponseEntity<Unit> split(@PathVariable @NotNull String processorName, @PathVariable int segmentId) {
        Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
        return this.runOnProcessorWithResponse(processorName, (Function1<? super StreamingEventProcessor, Boolean>)((Function1)new Function1<StreamingEventProcessor, Boolean>(this, segmentId){
            final /* synthetic */ AxonOpenAdminEndpoint this$0;
            final /* synthetic */ int $segmentId;

            public final boolean invoke(@NotNull StreamingEventProcessor it) {
                boolean replayAfter;
                EventTrackerStatus status;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                EventTrackerStatus eventTrackerStatus = status = (EventTrackerStatus)it.processingStatus().get(this.$segmentId);
                boolean bl = replayAfter = eventTrackerStatus != null && eventTrackerStatus.isReplaying();
                if (!it.isRunning()) {
                    AxonOpenAdminEndpoint.access$getLogger$p(this.this$0).error("Will not split segment since it is not running on this node");
                    return false;
                }
                it.splitSegment(this.$segmentId).get();
                if (replayAfter) {
                    if (it.isRunning()) {
                        it.shutDown();
                    }
                    it.resetTokens();
                    it.start();
                }
                return true;
            }
            {
                this.this$0 = axonOpenAdminEndpoint;
                this.$segmentId = n;
                super(1);
            }
        }));
    }

    @PostMapping(value={"/processor/{processorName}/merge/{segmentId}"})
    @NotNull
    public ResponseEntity<Unit> merge(@PathVariable @NotNull String processorName, @PathVariable int segmentId) {
        Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
        return this.runOnProcessorWithResponse(processorName, (Function1<? super StreamingEventProcessor, Boolean>)((Function1)new Function1<StreamingEventProcessor, Boolean>(this, segmentId){
            final /* synthetic */ AxonOpenAdminEndpoint this$0;
            final /* synthetic */ int $segmentId;

            public final boolean invoke(@NotNull StreamingEventProcessor it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AxonOpenAdminEndpoint.access$getLogger$p(this.this$0).warn("Starting merge");
                if (!it.isRunning()) {
                    AxonOpenAdminEndpoint.access$getLogger$p(this.this$0).error("Will not merge segment since it is not running on this node");
                    return false;
                }
                AxonOpenAdminEndpoint.access$getLogger$p(this.this$0).warn("Attempting merge!");
                EventTrackerStatus status = (EventTrackerStatus)it.processingStatus().get(this.$segmentId);
                if (status == null) {
                    AxonOpenAdminEndpoint.access$getLogger$p(this.this$0).warn("Merge failed");
                    return false;
                }
                status.getSegment().mergeableSegmentId();
                it.mergeSegment(this.$segmentId).get();
                AxonOpenAdminEndpoint.access$getLogger$p(this.this$0).warn("Merge successful");
                return true;
            }
            {
                this.this$0 = axonOpenAdminEndpoint;
                this.$segmentId = n;
                super(1);
            }
        }));
    }

    @PostMapping(value={"/processor/{processorName}/release/{segmentId}"})
    @NotNull
    public ResponseEntity<Unit> release(@PathVariable @NotNull String processorName, @PathVariable int segmentId) {
        Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
        return this.runOnProcessorWithResponse(processorName, (Function1<? super StreamingEventProcessor, Boolean>)((Function1)new Function1<StreamingEventProcessor, Boolean>(this, segmentId){
            final /* synthetic */ AxonOpenAdminEndpoint this$0;
            final /* synthetic */ int $segmentId;

            public final boolean invoke(@NotNull StreamingEventProcessor it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AxonOpenAdminEndpoint.access$getLogger$p(this.this$0).warn("Starting release");
                if ((EventTrackerStatus)it.processingStatus().get(this.$segmentId) == null) {
                    return false;
                }
                it.releaseSegment(this.$segmentId);
                return true;
            }
            {
                this.this$0 = axonOpenAdminEndpoint;
                this.$segmentId = n;
                super(1);
            }
        }));
    }

    @PostMapping(value={"/processor/{processorName}/stop"})
    @NotNull
    public ResponseEntity<Unit> stop(@PathVariable @NotNull String processorName) {
        Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
        return this.runOnProcessorWithResponse(processorName, (Function1<? super StreamingEventProcessor, Boolean>)((Function1)stop.1.INSTANCE));
    }

    @PostMapping(value={"/processor/{processorName}/start"})
    @NotNull
    public ResponseEntity<Unit> start(@PathVariable @NotNull String processorName) {
        Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
        return this.runOnProcessorWithResponse(processorName, (Function1<? super StreamingEventProcessor, Boolean>)((Function1)start.1.INSTANCE));
    }

    @PostMapping(value={"/processor/{processorName}/reset"})
    @NotNull
    public ResponseEntity<Unit> reset(@PathVariable @NotNull String processorName) {
        Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
        return this.runOnProcessorWithResponse(processorName, (Function1<? super StreamingEventProcessor, Boolean>)((Function1)reset.1.INSTANCE));
    }

    private ResponseEntity<Unit> runOnProcessorWithResponse(String processorName, Function1<? super StreamingEventProcessor, Boolean> block) {
        ResponseEntity responseEntity;
        Boolean result;
        Optional eventProcessor;
        Optional optional = eventProcessor = this.eventProcessingModule.eventProcessor(processorName, StreamingEventProcessor.class);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"eventProcessor");
        if (!optional.isPresent()) {
            ResponseEntity responseEntity2 = ResponseEntity.status((int)409).build();
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity2, (String)"ResponseEntity.status(409).build()");
            return responseEntity2;
        }
        Object object = block;
        if (object != null) {
            Function1<? super StreamingEventProcessor, Boolean> function1 = object;
            object = new AxonOpenAdminEndpoint$sam$java_util_function_Function$0(function1);
        }
        Boolean bl = result = eventProcessor.map((Function)object).orElse(false);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"result");
        if (bl.booleanValue()) {
            ResponseEntity responseEntity3 = ResponseEntity.ok().build();
            responseEntity = responseEntity3;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity3, (String)"ResponseEntity.ok().build()");
        } else {
            ResponseEntity responseEntity4 = ResponseEntity.status((int)500).build();
            responseEntity = responseEntity4;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity4, (String)"ResponseEntity.status(500).build()");
        }
        return responseEntity;
    }

    public AxonOpenAdminEndpoint(@NotNull TokenInformationService axonOpenAdminTokenStore, @NotNull ProcessorStatusService processorStatusService, @NotNull EventProcessingModule eventProcessingModule, @NotNull EventTailingService eventTailingService) {
        Intrinsics.checkNotNullParameter((Object)axonOpenAdminTokenStore, (String)"axonOpenAdminTokenStore");
        Intrinsics.checkNotNullParameter((Object)processorStatusService, (String)"processorStatusService");
        Intrinsics.checkNotNullParameter((Object)eventProcessingModule, (String)"eventProcessingModule");
        Intrinsics.checkNotNullParameter((Object)eventTailingService, (String)"eventTailingService");
        this.axonOpenAdminTokenStore = axonOpenAdminTokenStore;
        this.processorStatusService = processorStatusService;
        this.eventProcessingModule = eventProcessingModule;
        this.eventTailingService = eventTailingService;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public static final /* synthetic */ Logger access$getLogger$p(AxonOpenAdminEndpoint $this) {
        return $this.logger;
    }
}

