/*
 * Decompiled with CFR 0.152.
 */
package com.insidion.axon.openadmin;

import com.insidion.axon.openadmin.tokens.DummyTokenProvider;
import com.insidion.axon.openadmin.tokens.JdbcTokenProvider;
import com.insidion.axon.openadmin.tokens.JpaTokenProvider;
import com.insidion.axon.openadmin.tokens.TokenProvider;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventhandling.tokenstore.jdbc.JdbcTokenStore;
import org.axonframework.eventhandling.tokenstore.jpa.JpaTokenStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ComponentScan(value={"com.insidion.axon.openadmin"})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0017J\b\u0010\f\u001a\u00020\rH\u0017J\u001a\u0010\f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/insidion/axon/openadmin/AxonAdminConfiguration;", "", "contextPath", "", "(Ljava/lang/String;)V", "getContextPath", "()Ljava/lang/String;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logInitialization", "", "tokenProvider", "Lcom/insidion/axon/openadmin/tokens/DummyTokenProvider;", "Lcom/insidion/axon/openadmin/tokens/TokenProvider;", "tokenStore", "Lorg/axonframework/eventhandling/tokenstore/TokenStore;", "dataSource", "Ljavax/sql/DataSource;", "axon-open-admin-starter"})
public class AxonAdminConfiguration {
    private final Logger logger;
    @NotNull
    private final String contextPath;

    @PostConstruct
    public void logInitialization() {
        this.logger.info("Thanks for using AxonOpenAdmin in your application. To get started, navigate to " + this.getContextPath() + "/axon-open-admin");
    }

    @Bean
    @NotNull
    public TokenProvider tokenProvider(@NotNull TokenStore tokenStore, @Nullable DataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)tokenStore, (String)"tokenStore");
        if (tokenStore instanceof JpaTokenStore) {
            return new JpaTokenProvider((JpaTokenStore)tokenStore);
        }
        if (tokenStore instanceof JdbcTokenStore) {
            JdbcTokenStore jdbcTokenStore = (JdbcTokenStore)tokenStore;
            DataSource dataSource2 = dataSource;
            Intrinsics.checkNotNull((Object)dataSource2);
            return new JdbcTokenProvider(jdbcTokenStore, dataSource2);
        }
        throw (Throwable)new IllegalArgumentException("No matching store!");
    }

    @Bean
    @ConditionalOnMissingBean(value={TokenStore.class})
    @NotNull
    public DummyTokenProvider tokenProvider() {
        return new DummyTokenProvider();
    }

    @NotNull
    public String getContextPath() {
        return this.contextPath;
    }

    public AxonAdminConfiguration(@Value(value="${server.servlet.context-path:}") @NotNull String contextPath) {
        Intrinsics.checkNotNullParameter((Object)contextPath, (String)"contextPath");
        this.contextPath = contextPath;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }
}

