/*
 * Decompiled with CFR 0.152.
 */
package nl.codecentric.axon.openadmin.events;

import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nl.codecentric.axon.openadmin.events.EventTailingService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${axon.admin.base-url:axon-admin}"})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\n\b\u0001\u0010\b\u001a\u0004\u0018\u00010\tH\u0017\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0001\u0010\f\u001a\u00020\rH\u0017J\u0014\u0010\u000e\u001a\u00020\t2\n\b\u0001\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lnl/codecentric/axon/openadmin/events/AxonOpenAdminEventEndpoint;", "", "eventTailingService", "Lnl/codecentric/axon/openadmin/events/EventTailingService;", "(Lnl/codecentric/axon/openadmin/events/EventTailingService;)V", "getEvents", "", "Lnl/codecentric/axon/openadmin/events/EventTailingService$CaughtEvent;", "sinceIndex", "", "(Ljava/lang/Long;)Ljava/util/List;", "getEventsForAggregate", "aggregateId", "", "getIndex", "sinceTime", "axon-open-admin-starter"})
public class AxonOpenAdminEventEndpoint {
    private final EventTailingService eventTailingService;

    @GetMapping(value={"/index"})
    public long getIndex(@RequestParam(name="sinceTime", required=false) @Nullable String sinceTime) {
        long l;
        if (sinceTime != null) {
            Instant instant = Instant.parse(sinceTime);
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"Instant.parse(sinceTime)");
            l = this.eventTailingService.getIndexAt(instant);
        } else {
            l = this.eventTailingService.getCurrentIndex();
        }
        return l;
    }

    @GetMapping(value={"/events"})
    @NotNull
    public List<EventTailingService.CaughtEvent> getEvents(@RequestParam(name="sinceIndex", required=false) @Nullable Long sinceIndex) {
        return this.eventTailingService.getEvents(sinceIndex);
    }

    @GetMapping(value={"/events/{aggregateId}"})
    @NotNull
    public List<EventTailingService.CaughtEvent> getEventsForAggregate(@PathVariable @NotNull String aggregateId) {
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        return this.eventTailingService.getEvents(aggregateId);
    }

    public AxonOpenAdminEventEndpoint(@NotNull EventTailingService eventTailingService) {
        Intrinsics.checkNotNullParameter((Object)eventTailingService, (String)"eventTailingService");
        this.eventTailingService = eventTailingService;
    }
}

