/*
 * Decompiled with CFR 0.152.
 */
package nl.codecentric.axon.openadmin.command;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import nl.codecentric.axon.openadmin.command.AxonAdminCommand;
import nl.codecentric.axon.openadmin.command.AxonAdminCommandHandler;
import nl.codecentric.axon.openadmin.metrics.TokenStatusService;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${axon.admin.base-url:axon-admin}"})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0017R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lnl/codecentric/axon/openadmin/command/AxonOpenAdminCommandEndpoint;", "", "tokenStatusService", "Lnl/codecentric/axon/openadmin/metrics/TokenStatusService;", "handlers", "", "Lnl/codecentric/axon/openadmin/command/AxonAdminCommandHandler;", "(Lnl/codecentric/axon/openadmin/metrics/TokenStatusService;Ljava/util/List;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "executeCommand", "Lorg/springframework/http/ResponseEntity;", "", "command", "Lnl/codecentric/axon/openadmin/command/AxonAdminCommand;", "axon-open-admin-starter"})
public class AxonOpenAdminCommandEndpoint {
    private final Logger logger;
    private final TokenStatusService tokenStatusService;
    private final List<AxonAdminCommandHandler> handlers;

    @PostMapping(value={"/command"})
    @NotNull
    public ResponseEntity<Unit> executeCommand(@RequestBody @NotNull AxonAdminCommand command) {
        Object v1;
        block3: {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            if (command.getNodeId() != null && Intrinsics.areEqual((Object)command.getNodeId(), (Object)this.tokenStatusService.getNodeId()) ^ true) {
                ResponseEntity responseEntity = ResponseEntity.noContent().build();
                Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ResponseEntity.noContent().build()");
                return responseEntity;
            }
            this.logger.info("Executing command for Axon Admin: {}", (Object)command);
            Iterable $this$firstOrNull$iv = this.handlers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AxonAdminCommandHandler it = (AxonAdminCommandHandler)element$iv;
                boolean bl = false;
                if (!(it.getCommandType() == command.getType())) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        AxonAdminCommandHandler axonAdminCommandHandler = v1;
        if (axonAdminCommandHandler == null) {
            throw (Throwable)new IllegalArgumentException("No known handler for command type " + (Object)((Object)command.getType()));
        }
        AxonAdminCommandHandler axonAdminCommandHandler2 = axonAdminCommandHandler;
        axonAdminCommandHandler2.executeCommand(command);
        ResponseEntity responseEntity = ResponseEntity.ok().build();
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ResponseEntity.ok().build()");
        return responseEntity;
    }

    public AxonOpenAdminCommandEndpoint(@NotNull TokenStatusService tokenStatusService, @NotNull List<? extends AxonAdminCommandHandler> handlers) {
        Intrinsics.checkNotNullParameter((Object)tokenStatusService, (String)"tokenStatusService");
        Intrinsics.checkNotNullParameter(handlers, (String)"handlers");
        this.tokenStatusService = tokenStatusService;
        this.handlers = handlers;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }
}

