/*
 * Decompiled with CFR 0.152.
 */
package nl.cloudfarming.client.area.field.shape;

import java.beans.IntrospectionException;
import java.util.Collections;
import java.util.List;
import javax.swing.ActionMap;
import nl.cloudfarming.client.area.field.shape.ImportLayer;
import nl.cloudfarming.client.area.field.shape.Shape;
import nl.cloudfarming.client.area.field.shape.ShapeNode;
import nl.cloudfarming.client.geoviewer.Layer;
import nl.cloudfarming.client.model.Bean;
import nl.cloudfarming.client.model.CommonModelService;
import nl.cloudfarming.client.model.ShapeFile;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public class ImportDataProvider
extends CommonModelService {
    private final ShapeFile plotFile;
    private ImportLayer importLayer;
    private final ShapeNodeKeys keys = new ShapeNodeKeys(this);

    public ImportDataProvider(ShapeFile plotFile) {
        this.plotFile = plotFile;
        this.importLayer = new ImportLayer(plotFile, this);
        this.initExplorer();
    }

    protected final void initExplorer() {
        ExplorerManager manager = new ExplorerManager();
        this.setExplorerManager(manager, new ActionMap());
        this.getExplorerManager().setRootContext((Node)new AbstractNode((Children)this.keys));
        this.keys.addNotify();
    }

    protected String getModuleName() {
        return "area-field";
    }

    public void save(Bean bean) {
    }

    public ImportLayer getLayer() {
        return this.importLayer;
    }

    public List<Shape> getShapes() {
        return Collections.unmodifiableList(this.importLayer.getObjects());
    }

    public void addShape(Shape layerObject) {
        this.importLayer.addObject(layerObject);
    }

    class ShapeNodeKeys
    extends Children.Keys<Shape> {
        private final ImportDataProvider provider;

        public ShapeNodeKeys(ImportDataProvider provider) {
            super(false);
            this.provider = provider;
        }

        protected void addNotify() {
            this.setKeys(ImportDataProvider.this.getShapes());
        }

        protected Node[] createNodes(Shape shape) {
            try {
                return new Node[]{new ShapeNode((Layer)ImportDataProvider.this.importLayer, shape)};
            }
            catch (IntrospectionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }
    }
}

