/*
 * Decompiled with CFR 0.152.
 */
package nl.cloudfarming.client.area.field;

import java.beans.IntrospectionException;
import java.util.Date;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.swing.ActionMap;
import nl.cloudfarming.client.area.AreaService;
import nl.cloudfarming.client.area.field.FieldLayer;
import nl.cloudfarming.client.area.field.HelpLineLayer;
import nl.cloudfarming.client.area.field.explorer.GeometryRootNode;
import nl.cloudfarming.client.model.AbLine;
import nl.cloudfarming.client.model.CommonModelService;
import nl.cloudfarming.client.model.DataProvider;
import nl.cloudfarming.client.model.Field;
import nl.cloudfarming.client.model.HelpLine;
import nl.cloudfarming.client.model.PartField;
import nl.cloudfarming.client.model.Persistable;
import nl.cloudfarming.client.model.ProductionUnit;
import nl.cloudfarming.client.model.ShapeFile;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class FieldAreaService
extends CommonModelService
implements AreaService {
    protected String getModuleName() {
        return "area-field";
    }

    public final List<Field> findAllCurrentFields() {
        this.startTransaction();
        Query query = this.getEntityManager().createNamedQuery("findAllValidFields");
        query.setParameter("date", (Object)new Date());
        return query.getResultList();
    }

    public final void createNewField(Field field) {
        this.persistInTransaction((Persistable)field);
    }

    public void createNewHelpLine(HelpLine helpLine) {
        this.persistInTransaction((Persistable)helpLine);
    }

    public void createNewAbLine(AbLine abLine) {
        this.persistInTransaction((Persistable)abLine);
    }

    public final void saveFieldChanges(Field field) {
        this.mergeAndPersistInTransaction((Persistable)field);
    }

    public final void savePartFieldChanges(PartField partField) {
        this.mergeAndPersistInTransaction((Persistable)partField);
    }

    public final void createNewShapeFile(ShapeFile shapeFile) {
        this.persistInTransaction((Persistable)shapeFile);
    }

    public void createNewPartField(PartField pf) {
        this.persistInTransaction((Persistable)pf);
    }

    public List<ProductionUnit> findProductionUnitsByDate(Date date) {
        this.startTransaction();
        Query query = this.getEntityManager().createNamedQuery("findAllProductionUnitsByDate");
        query.setParameter("date", (Object)date);
        return query.getResultList();
    }

    public boolean endField(Field field) {
        this.startTransaction();
        if (field.getId() == 0L) {
            throw new IllegalArgumentException("the provided field is not a persisted entity");
        }
        Date now = new Date();
        if (field.getStartDate() == null || field.getStartDate().before(now)) {
            field.setEndDate(now);
            this.saveFieldChanges(field);
            return true;
        }
        return false;
    }

    protected void initExplorer() {
        try {
            ExplorerManager manager = new ExplorerManager();
            FieldLayer fieldLayer = new FieldLayer("service.explorer.layerlist.field_node.name", (DataProvider)this);
            HelpLineLayer lineLayer = new HelpLineLayer("service.explorer.layerlist.line_node.name", (DataProvider)this);
            manager.setRootContext((Node)new GeometryRootNode(fieldLayer, lineLayer));
            manager.getRootContext().setDisplayName(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"service.explorer.rootnode.displayname"));
            ActionMap map = new ActionMap();
            map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)manager));
            map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)manager));
            map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)manager));
            map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)manager, (boolean)true));
            this.setExplorerManager(manager, map);
        }
        catch (IntrospectionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public List<PartField> findPartFieldsByDate(Date date) {
        this.startTransaction();
        Query query = this.getEntityManager().createNamedQuery("findAllPartFieldsByDate");
        query.setParameter("date", (Object)date);
        return query.getResultList();
    }

    public ShapeFile findShapeFileByNameAndChecksum(String name, String checksum) {
        this.startTransaction();
        Query query = this.getEntityManager().createNamedQuery("findShapeFileByNameAndChecksum");
        query.setParameter("fileName", (Object)name);
        query.setParameter("checksum", (Object)checksum);
        try {
            return (ShapeFile)query.getSingleResult();
        }
        catch (NoResultException ner) {
            return null;
        }
    }

    public Field findFieldById(long id) {
        this.startTransaction();
        return (Field)this.getEntityManager().find(Field.class, (Object)id);
    }

    public List<Field> findAllActiveFields() {
        this.startTransaction();
        Query query = this.getEntityManager().createNamedQuery("findAllActiveFields");
        return query.getResultList();
    }

    public List<HelpLine> findAllHelpLines() {
        this.startTransaction();
        Query query = this.getEntityManager().createNamedQuery("findAllHelpLines");
        return query.getResultList();
    }

    public void removeField(Field field) {
        this.startTransaction();
        if (field.getId() == 0L) {
            throw new IllegalArgumentException("trying to remove non persisted field");
        }
        if (field.getPartFields().isEmpty()) {
            this.getEntityManager().remove(this.getEntityManager().merge((Object)field));
            this.getEntityManager().getTransaction().commit();
        } else {
            this.endField(field);
        }
    }

    public void removeHelpLine(HelpLine line) {
        this.startTransaction();
        if (line.getId() == 0L) {
            throw new IllegalArgumentException("trying to remove non persisted line");
        }
        this.getEntityManager().remove(this.getEntityManager().merge((Object)line));
        this.getEntityManager().getTransaction().commit();
    }
}

