/**
 * Copyright (C) 2010 Cloudfarming <info@cloudfarming.nl>
 *
 * Licensed under the Eclipse Public License - v 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.eclipse.org/legal/epl-v10.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package nl.cloudfarming.client.area.field.pref;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.openide.util.NbBundle;

/**
 *
 * @author Timon Veenstra
 */
public class FieldOptionsPanel extends JPanel {

    private final JCheckBox plotBox = new JCheckBox();
    private final JCheckBox fieldBox = new JCheckBox();
    private final JTextField shapeAttPolygon = new JTextField();
    private final JTextField shapeAttName = new JTextField();

    private final FieldOptionsController controller;
    private final ChangeListener changeListener = new ChangeListener();

    public FieldOptionsPanel(final FieldOptionsController controller) {
        setLayout(new MigLayout("wrap 2"));
        this.controller = controller;
        //
        // add plot checkbox
        //
        add(new JLabel(NbBundle.getMessage(this.getClass(), "plot.options.check.plot")));
        plotBox.addActionListener(changeListener);
        add(plotBox);
        //
        // add field checkbox
        //
        add(new JLabel(NbBundle.getMessage(this.getClass(), "plot.options.check.field")));
        fieldBox.addActionListener(changeListener);
        add(fieldBox);
        //
        // add shape attribute polygon
        //
        add(new JLabel(NbBundle.getMessage(this.getClass(), "plot.options.att.polygon")));
        shapeAttPolygon.addActionListener(changeListener);
        add(shapeAttPolygon);
        //
        // add shape attribute name
        //
        add(new JLabel(NbBundle.getMessage(this.getClass(), "plot.options.att.name")));
        shapeAttName.addActionListener(changeListener);
        add(shapeAttName);
    }

    public void setPlotBox(boolean selected) {
        plotBox.setSelected(selected);
    }

    public void setFieldBox(boolean selected) {
        fieldBox.setSelected(selected);
    }

    public boolean getPlotBox(){
        return plotBox.isSelected();
    }

    public boolean getFieldBox(){
        return fieldBox.isSelected();
    }

    public void setShapeAttPolygon(String polygon){
        this.shapeAttPolygon.setText(polygon);
    }

    public String getShapeAttPolygon(){
        return this.shapeAttPolygon.getText();
    }

    public void setShapeAttName(String name){
        this.shapeAttName.setText(name);
    }

    public String getShapeAttName(){
        return this.shapeAttName.getText();
    }



    class ChangeListener implements ActionListener{

        @Override
        public void actionPerformed(ActionEvent e) {
            controller.changed();
        }

    }
}
