/**
 * Copyright (C) 2010 Cloudfarming <info@cloudfarming.nl>
 *
 * Licensed under the Eclipse Public License - v 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.eclipse.org/legal/epl-v10.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package nl.cloudfarming.client.area.field.explorer;

import java.beans.IntrospectionException;
import java.util.List;
import nl.cloudfarming.client.area.field.FieldLayer;
import nl.cloudfarming.client.area.field.HelpLineLayer;
import nl.cloudfarming.client.geoviewer.LayerNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

/**
 * 2 nodes, one for fields, one for lines.
 * 
 * @author Gerben Feenstra
 */
public class GeometryRootNodeFactory extends ChildFactory<LayerNode> {

    private FieldLayer fieldLayer = null;
    private HelpLineLayer lineLayer = null;

    public GeometryRootNodeFactory(FieldLayer fieldLayer, HelpLineLayer lineLayer) {
        this.fieldLayer = fieldLayer;
        this.lineLayer = lineLayer;
    }

    @Override
    protected boolean createKeys(List<LayerNode> toPopulate) {
        try {
            toPopulate.add(new FieldRootNode(fieldLayer));
            toPopulate.add(new HelpLineRootNode(lineLayer));  
        } catch (IntrospectionException ex) {
            Exceptions.printStackTrace(ex);
        }

        return true;
    }

    @Override
    protected Node createNodeForKey(LayerNode key) {
        try {
            if (key instanceof FieldRootNode) {
                return new FieldRootNode(fieldLayer);
            } else { // HelpLineRootNode
                return new HelpLineRootNode(lineLayer);
            }
        } catch (IntrospectionException ex) {
            Exceptions.printStackTrace(ex);
            return null;
        }
    }
}
