/**
 * Copyright (C) 2010 Cloudfarming <info@cloudfarming.nl>
 *
 * Licensed under the Eclipse Public License - v 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.eclipse.org/legal/epl-v10.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package nl.cloudfarming.client.area.field.explorer;

import java.beans.IntrospectionException;
import nl.cloudfarming.client.area.field.FieldLayer;
import nl.cloudfarming.client.area.field.HelpLineLayer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;

/**
 *
 * @author Gerben Feenstra
 */
public class GeometryRootNode extends AbstractNode{
    public GeometryRootNode(FieldLayer fieldLayer, HelpLineLayer lineLayer) throws IntrospectionException {
        super(Children.create(new GeometryRootNodeFactory(fieldLayer, lineLayer), true));
        setIconBaseWithExtension("nl/cloudfarming/client/icon/map-icon.png");
    }
}
