/**
 * Copyright (C) 2010 Cloudfarming <info@cloudfarming.nl>
 *
 * Licensed under the Eclipse Public License - v 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.eclipse.org/legal/epl-v10.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package nl.cloudfarming.client.area.field.explorer;

import java.beans.IntrospectionException;
import java.util.List;
import nl.cloudfarming.client.area.AreaEventKey;
import nl.cloudfarming.client.area.field.AreaFieldModule;
import nl.cloudfarming.client.area.field.FieldAreaService;
import nl.cloudfarming.client.area.field.FieldLayer;
import nl.cloudfarming.client.area.field.FieldLayerObject;
import nl.cloudfarming.client.model.Field;
import nl.cloudfarming.eventbus.GuiEvent;
import nl.cloudfarming.eventbus.GuiEventBus;
import nl.cloudfarming.eventbus.GuiEventKey;
import nl.cloudfarming.eventbus.GuiEventListener;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

/**
 *
 * @author Timon Veenstra
 */
public class FieldNodeFactory extends ChildFactory<Field> {

    private FieldAreaService service;
    private final FieldLayer layer;


    public FieldNodeFactory(FieldLayer layer) {
        this.layer = layer;
        GuiEventBus.addListener(new GuiEventListener() {

            @Override
            public void onEvent(GuiEvent event) {
                refresh(true);
            }

            @Override
            public boolean listensTo(GuiEventKey guiEventKey) {
                return guiEventKey.equals(AreaEventKey.IMPORT_SAVED) || guiEventKey.equals(AreaEventKey.FIELD_REMOVED);
            }

            @Override
            public String getModuleName() {
                return AreaFieldModule.MODULE_NAME;
            }
        });
    }

    @Override
    protected Node createNodeForKey(Field key) {
        try {
            FieldLayerObject layerObject = new FieldLayerObject(key);
            layer.addObject(layerObject);
            return new FieldNode(this.layer,layerObject, getService());
        } catch (IntrospectionException ex) {
            Exceptions.printStackTrace(ex);
            return null;
        }
    }

    @Override
    protected boolean createKeys(List<Field> toPopulate) {
        toPopulate.addAll(getService().findAllActiveFields());
        return true;
    }

    public FieldAreaService getService() {
        if (this.service == null) {
            this.service = Lookup.getDefault().lookup(FieldAreaService.class);
        }
        return this.service;
    }

    public void setService(FieldAreaService service) {
        this.service = service;
    }
}
