/**
 * Copyright (C) 2010 Cloudfarming <info@cloudfarming.nl>
 *
 * Licensed under the Eclipse Public License - v 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.eclipse.org/legal/epl-v10.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package nl.cloudfarming.client.area.field;

import com.vividsolutions.jts.geom.MultiPolygon;
import nl.cloudfarming.client.geoviewer.LayerObject;
import nl.cloudfarming.client.geoviewer.LayerObjectAction;
import nl.cloudfarming.client.model.PartField;
import nl.cloudfarming.client.util.GeometryUtil;

/**
 * Layer object that represents the specified field-object
 * 
 * @author Timon Veenstra
 */
public class PartFieldLayerObject implements LayerObject<MultiPolygon, PartField> {

    /**
     * Geometry of the underlying Field
     */
    private final MultiPolygon geometry;
    
    /**
     * The field this FieldLayerObject represents
     */
    private final PartField field;

    public PartFieldLayerObject(final PartField field) {
        this.field = field;
        geometry = (MultiPolygon) GeometryUtil.wktToGeometry(field.getWKT());            
    }

    @Override
    public MultiPolygon getGeometry() {
        return this.geometry;
    }

    @Override
    public String getKey() {
        return Long.toString(this.field.getId());
    }

    @Override
    public String getTooltipText() {
        return Long.toString(this.field.getId()) + " " + this.field.getName();
    }

    @Override
    public Long getKeyAttributeValue() {
        return this.field.getId();
    }

    @Override
    public long getId() {
        return this.field.getId();
    }

    @Override
    public PartField getObject() {
        return this.field;
    }

    @Override
    public LayerObjectAction[] getActions() {
        return null;
    }

    @Override
    public void save() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

}
