/**
 * Copyright (C) 2010 Cloudfarming <info@cloudfarming.nl>
 *
 * Licensed under the Eclipse Public License - v 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.eclipse.org/legal/epl-v10.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package nl.cloudfarming.client.area.field;

import nl.cloudfarming.client.geoviewer.LayerObjectAction;

/**
 *
 * 
 * Implementation can register themselves in the lookup by using
 * @ServiceProvider(service=LineAction.class).
 * 
 * Implementation should be stateless because the same instance could
 * be linked to more then one fields.
 * 
 * Classes retrieving implementation from the lookup should in general
 * use the found implementations as template and create new instances
 * from them to avoid state problems.
 * 
 * @author Gerben Feenstra & Merijn Zengers
 */
public abstract class LineAction extends LayerObjectAction {

    public LineAction(String name) {
        super(name);
    }
    
}
