/**
 * Copyright (C) 2010 Cloudfarming <info@cloudfarming.nl>
 *
 * Licensed under the Eclipse Public License - v 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.eclipse.org/legal/epl-v10.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package nl.cloudfarming.client.area.field;

import java.awt.Color;
import nl.cloudfarming.client.geoviewer.Palette;
import org.netbeans.api.visual.model.ObjectState;

/**
 * Color palette for fields
 * 
 * @author Timon Veenstra
 */
public class FieldPalette implements Palette {

    private final Color defaultColor = Color.BLACK;
    private final Color colorSelected = Color.RED;
    private final Color colorHoovered = Color.BLUE;

    @Override
    public Color getColorForValue(final Object value) {
        return defaultColor;
    }

    @Override
    public Color getColorForState(final ObjectState state) {
        if (state.isSelected()) {
            return colorSelected;
        }
        if (state.isHovered() || state.isObjectHovered()) {
            return colorHoovered;
        }
        return defaultColor;
    }
}
