/*
 * Decompiled with CFR 0.152.
 */
package nl.cloudfarming.client.area.field;

import com.vividsolutions.jts.geom.MultiPolygon;
import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.cloudfarming.client.area.AreaService;
import nl.cloudfarming.client.area.field.FieldAction;
import nl.cloudfarming.client.area.field.FieldAreaService;
import nl.cloudfarming.client.geoviewer.LayerObject;
import nl.cloudfarming.client.geoviewer.LayerObjectAction;
import nl.cloudfarming.client.model.Field;
import nl.cloudfarming.client.util.GeometryUtil;
import org.openide.util.Lookup;

public class FieldLayerObject
implements LayerObject<MultiPolygon, Field> {
    private final MultiPolygon geometry;
    private final Field plot;
    private AreaService service;
    private static final Logger LOG = Logger.getLogger("FieldLayerObject.Actions");

    public FieldLayerObject(Field plot) throws IntrospectionException {
        this.plot = plot;
        this.geometry = (MultiPolygon)GeometryUtil.wktToGeometry((String)plot.getWKT());
        this.service = this.getPlotAreaService();
    }

    public MultiPolygon getGeometry() {
        return this.geometry;
    }

    public String getKey() {
        return Long.toString(this.plot.getId());
    }

    public String getTooltipText() {
        return Long.toString(this.plot.getId()) + " " + this.plot.getName();
    }

    public Long getKeyAttributeValue() {
        return this.plot.getId();
    }

    public long getId() {
        return this.plot.getId();
    }

    public Field getObject() {
        return this.plot;
    }

    public LayerObjectAction[] getActions() {
        ArrayList layerObjectActions = new ArrayList();
        for (FieldAction fieldAction : Lookup.getDefault().lookupAll(FieldAction.class)) {
            try {
                layerObjectActions.add(((Object)((Object)fieldAction)).getClass().newInstance());
            }
            catch (InstantiationException ex) {
                LOG.log(Level.FINE, "Instantiation of new {0} failed", ((Object)((Object)fieldAction)).getClass());
            }
            catch (IllegalAccessException ex) {
                LOG.log(Level.FINE, "Instantiation of new {0} failed", ((Object)((Object)fieldAction)).getClass());
            }
        }
        return layerObjectActions.toArray(new LayerObjectAction[0]);
    }

    public void save() {
        this.service.saveFieldChanges(this.plot);
    }

    protected final AreaService getPlotAreaService() {
        return this.service == null ? (AreaService)Lookup.getDefault().lookup(FieldAreaService.class) : this.service;
    }

    protected void setPlotAreaService(FieldAreaService service) {
        this.service = service;
    }
}

