/**
 * Copyright (C) 2010 Cloudfarming <info@cloudfarming.nl>
 *
 * Licensed under the Eclipse Public License - v 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.eclipse.org/legal/epl-v10.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package nl.cloudfarming.client.area.field.shape;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import nl.cloudfarming.client.area.field.AreaFieldModule;
import nl.cloudfarming.client.geoviewer.Layer;
import nl.cloudfarming.client.geoviewer.LayerAction;
import org.jdesktop.swingx.JXPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/**
 * Mark selected shapes as Plot of as Skip (to skip linking the selected plots)
 * 
 * @author Timon Veenstra
 */
public class MarkAllShapesAsAction extends LayerAction {

    private Dialog dlg;
    private Layer layer;
    private final JComboBox comboBox = new JComboBox(Shape.ShapeType.values());

    public MarkAllShapesAsAction() {
        putValue(NAME, NbBundle.getMessage(AreaFieldModule.class, "action.mark_all_shapes_as.name"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        layer = Utilities.actionsGlobalContext().lookup(Layer.class);
        assert layer != null;

        JXPanel panel = new JXPanel(new MigLayout("wrap 2"));

        panel.add(new JLabel(NbBundle.getMessage(AreaFieldModule.class, "action.mark_all_shapes_as.dialog.label.choose_shape")));
        panel.add(comboBox);

        DialogDescriptor dd = new DialogDescriptor(panel, NbBundle.getMessage(AreaFieldModule.class, "action.mark_all_shapes_as.dialog.title"));
        dd.setOptions(new Object[]{getOkButton(), getCancelButton()});
        dlg = DialogDisplayer.getDefault().createDialog(dd);
        dlg.setVisible(true);
    }

    /**
     * Create an OK button to show in the dialog
     * @return The OK button + action to mark the selected shapes.
     */
    private JButton getOkButton() {
        JButton jButtonOK = new JButton();
        jButtonOK.setText(NbBundle.getMessage(AreaFieldModule.class, "action.mark_all_shapes_as.dialog.button.ok"));
        jButtonOK.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(final ActionEvent ae) {
                dlg.setVisible(false);
                if (comboBox.getSelectedItem() != null) {
                    if (layer instanceof ImportLayer) {
                        ImportLayer importLayer = (ImportLayer) layer;
                        for (Shape layerObject : importLayer.getObjects()) {
                            layerObject.getObject().setType((Shape.ShapeType) comboBox.getSelectedItem());
                        }
                    } else {
                        throw new IllegalStateException("MarkAllShapesAsAction is only applicable to ImportLayers ");
                    }
                }
            }
        });
        return jButtonOK;
    }

    /**
     * Create an Cancel button to show in the dialog
     * @return The Cancel button + action to hide the dialog
     */
    private JButton getCancelButton() {
        JButton jButtonCancel = new JButton();
        jButtonCancel.setText(NbBundle.getMessage(AreaFieldModule.class, "action.mark_all_shapes_as.dialog.button.cancel"));
        jButtonCancel.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(final ActionEvent ae) {
                dlg.setVisible(false);
            }
        });
        return jButtonCancel;
    }
}