/**
 * Copyright (C) 2010 Cloudfarming <info@cloudfarming.nl>
 *
 * Licensed under the Eclipse Public License - v 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.eclipse.org/legal/epl-v10.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package nl.cloudfarming.client.area.field.pref;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

/**
 *
 * @author Timon Veenstra
 */
@OptionsPanelController.TopLevelRegistration(categoryName = "#OptionsCategory_Name_Plot",
iconBase = "nl/cloudfarming/client/area/field/leaf-icon32.png",
keywords = "#OptionsCategory_Keywords_Plot",
keywordsCategory = "Plot")
public class FieldOptionsController extends OptionsPanelController {

    private FieldOptionsPanel panel;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean changed;

    @Override
    public void update() {
        panel.setPlotBox(Boolean.valueOf(AreaFieldPreference.SHAPE_CONTAINTS_FIELD.getValue()));
        panel.setFieldBox(Boolean.valueOf(AreaFieldPreference.SHAPE_CONTAINTS_PARTFIELD.getValue()));
        panel.setShapeAttName(AreaFieldPreference.SHAPE_ATT_NAME.getValue());
        panel.setShapeAttPolygon(AreaFieldPreference.SHAPE_ATT_POLYGON.getValue());
        changed = false;
    }

    @Override
    public void applyChanges() {
        AreaFieldPreference.SHAPE_CONTAINTS_PARTFIELD.saveValue(Boolean.toString(panel.getFieldBox()));
        AreaFieldPreference.SHAPE_CONTAINTS_FIELD.saveValue(Boolean.toString(panel.getPlotBox()));
        AreaFieldPreference.SHAPE_ATT_NAME.saveValue(panel.getShapeAttName());
        AreaFieldPreference.SHAPE_ATT_POLYGON.saveValue(panel.getShapeAttPolygon());
        changed = false;
    }

    @Override
    public void cancel() {
        // need not do anything special, if no changes have been persisted yet
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean isChanged() {
        return changed;
    }

    @Override
    public HelpCtx getHelpCtx() {
        return null; // new HelpCtx("...ID") if you have a help set
    }

    @Override
    public JComponent getComponent(Lookup masterLookup) {
        return getPanel();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        pcs.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        pcs.removePropertyChangeListener(l);
    }

    private FieldOptionsPanel getPanel() {
        if (panel == null) {
            panel = new FieldOptionsPanel(this);
        }
        return panel;
    }

    void changed() {
        if (!changed) {
            changed = true;
            pcs.firePropertyChange(OptionsPanelController.PROP_CHANGED, false, true);
        }
        pcs.firePropertyChange(OptionsPanelController.PROP_VALID, null, null);
    }
}
