/**
 * Copyright (C) 2010 Cloudfarming <info@cloudfarming.nl>
 *
 * Licensed under the Eclipse Public License - v 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.eclipse.org/legal/epl-v10.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package nl.cloudfarming.client.area.field;

import nl.cloudfarming.client.geoviewer.Category;
import nl.cloudfarming.client.geoviewer.ObjectLayer;
import nl.cloudfarming.client.model.DataProvider;
import org.openide.util.NbBundle;

/**
 * Layer for plots
 * @author Timon Veenstra
 */
public class FieldLayer extends ObjectLayer<FieldLayerObject> {

    public FieldLayer(final String nodeNameKey, final DataProvider dataProvider) {
        super(new FieldPalette(), Category.AREA, NbBundle.getMessage(FieldLayer.class, nodeNameKey), dataProvider, true);
    }
}
