/**
 * Copyright (C) 2010 Cloudfarming <info@cloudfarming.nl>
 *
 * Licensed under the Eclipse Public License - v 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.eclipse.org/legal/epl-v10.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package nl.cloudfarming.client.area.field;

import nl.cloudfarming.client.db.PersistingModule;
import org.openide.util.lookup.ServiceProvider;

/**
 * Persisting module for module area-field
 * 
 * @author Timon Veenstra
 */
@ServiceProvider(service = PersistingModule.class)
public final class AreaFieldModule implements PersistingModule {

    /**
     * The name of this module
     */
    public static final String MODULE_NAME = "area-field";
    
    /**
     * Name of the persistence unit for this module
     */
    public static final String PERSISTENCE_UNIT = "nl-cloudfarming-area-field";

    @Override
    public final String getPersistenceUnit() {
        return PERSISTENCE_UNIT;
    }

    @Override
    public final String getModuleName() {
        return MODULE_NAME;
    }

}
