/*
 * Decompiled with CFR 0.152.
 */
package nl.cloudfarming.client.area.field.shape;

import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.io.ParseException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import nl.cloudfarming.client.area.field.AreaFieldModule;
import nl.cloudfarming.client.area.field.ParseWKTException;
import nl.cloudfarming.client.area.field.pref.AreaFieldPreference;
import nl.cloudfarming.client.area.field.shape.ImportDataProvider;
import nl.cloudfarming.client.geoviewer.Layer;
import nl.cloudfarming.client.geoviewer.events.LayerEventKey;
import nl.cloudfarming.client.geoviewer.events.NewLayerEvent;
import nl.cloudfarming.client.logging.AppLogFactory;
import nl.cloudfarming.client.logging.AppLogger;
import nl.cloudfarming.client.model.FieldFile;
import nl.cloudfarming.client.model.Shape;
import nl.cloudfarming.client.util.MD5Sum;
import nl.cloudfarming.client.util.NotAFileException;
import nl.cloudfarming.eventbus.BaseGuiEventProducer;
import nl.cloudfarming.eventbus.GuiEvent;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ShapeFileProcessor {
    private static final String LOGKEY_PROCESSING_SUMMARY_PROCESSEDMSG = "shape.fileprocessor.loginfo.process_end";
    private static final String LOGKEY_PROCESSING_START = "shape.fileprocessor.loginfo.process_start";
    private static final String LOGKEY_PROCESSING_PARSE_ERROR = "shape.fileprocessor.logerror.process_error";
    private final File shapeFile;
    private final LayerEventProducer layerEventProducer = new LayerEventProducer();
    private static final AppLogger LOG = AppLogFactory.getLogger(AreaFieldModule.class);
    private static final String DEFAULT_SHAPE_NAME = NbBundle.getMessage(AreaFieldModule.class, (String)"shape.fileprocessor.default_shape_name");

    public ShapeFileProcessor(File shapeFile) {
        this.shapeFile = shapeFile;
    }

    public void process() throws NotAFileException {
        ShapefileDataStore shpDataStore = null;
        if (this.shapeFile.isFile()) {
            try {
                LOG.info(LOGKEY_PROCESSING_START, new Object[]{this.shapeFile.getName()});
                String checkSum = MD5Sum.getHex((byte[])MD5Sum.createChecksum((InputStream)new FileInputStream(this.shapeFile)));
                FieldFile plotFile = new FieldFile();
                plotFile.setChecksum(checkSum);
                plotFile.setFileCreated(new Date(this.shapeFile.lastModified()));
                plotFile.setFileName(this.shapeFile.getName());
                plotFile.setFileRead(new Date());
                ImportDataProvider importDataProvider = new ImportDataProvider(plotFile);
                shpDataStore = new ShapefileDataStore(this.shapeFile.toURI().toURL());
                String typeName = shpDataStore.getTypeNames()[0];
                SimpleFeatureSource featureSource = shpDataStore.getFeatureSource(typeName);
                FeatureCollection result = featureSource.getFeatures();
                FeatureIterator iterator = result.features();
                while (iterator.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)iterator.next();
                    Shape shape = this.parseShape(feature);
                    importDataProvider.addShape(shape);
                }
                iterator.close();
                LOG.info(LOGKEY_PROCESSING_SUMMARY_PROCESSEDMSG, new Object[]{this.shapeFile.getName()});
                NewLayerEvent event = new NewLayerEvent((Layer)importDataProvider.getLayer());
                this.layerEventProducer.triggerEvent((GuiEvent)event);
            }
            catch (NoSuchAlgorithmException ex) {
                StringBuilder exBuilder = new StringBuilder("No such algorithmException ");
                exBuilder.append(this.shapeFile.getName());
                LOG.error(exBuilder.toString(), (Throwable)ex);
            }
            catch (IOException ex) {
                StringBuilder exBuilder = new StringBuilder("IOException while reading ");
                exBuilder.append(this.shapeFile.getName());
                LOG.error(exBuilder.toString(), (Throwable)ex);
            }
        } else {
            StringBuilder sb = new StringBuilder("The File-object [");
            sb.append(this.shapeFile.getPath());
            sb.append("] passed to this ShapeFileProcessor instance is not a File");
            throw new NotAFileException(sb.toString());
        }
    }

    public Shape parseShape(SimpleFeature payload) throws ParseWKTException {
        int attIndexPlotPoly = payload.getFeatureType().indexOf(AreaFieldPreference.SHAPE_ATT_POLYGON.getValue());
        int attIndexPlotName = payload.getFeatureType().indexOf(AreaFieldPreference.SHAPE_ATT_NAME.getValue());
        MultiPolygon polygon = null;
        if (attIndexPlotPoly >= 0) {
            polygon = (MultiPolygon)payload.getAttribute(attIndexPlotPoly);
        }
        String shapeName = DEFAULT_SHAPE_NAME;
        if (attIndexPlotName >= 0) {
            shapeName = (String)payload.getAttribute(attIndexPlotName);
        }
        try {
            Shape shape = new Shape(polygon.toString());
            shape.setName(shapeName);
            shape.setType(Shape.ShapeType.SKIP);
            return shape;
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            LOG.error(LOGKEY_PROCESSING_PARSE_ERROR, new Object[]{this.shapeFile.getName()});
            throw new ParseWKTException("Failed creating shape from multipolygon: " + polygon.toString(), ex);
        }
    }

    private class LayerEventProducer
    extends BaseGuiEventProducer {
        public LayerEventProducer() {
            super(LayerEventKey.class);
        }
    }
}

