/*
 * Decompiled with CFR 0.152.
 */
package nl.cloudfarming.client.area.field.shape;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import nl.cloudfarming.client.area.AreaEventKey;
import nl.cloudfarming.client.area.AreaService;
import nl.cloudfarming.client.area.field.AreaFieldModule;
import nl.cloudfarming.client.area.field.FieldAreaService;
import nl.cloudfarming.client.area.field.shape.ImportLayer;
import nl.cloudfarming.client.area.field.shape.ShapeLayerObject;
import nl.cloudfarming.client.geoviewer.EditLayerAction;
import nl.cloudfarming.client.geoviewer.Layer;
import nl.cloudfarming.client.geoviewer.events.LayerEventKey;
import nl.cloudfarming.client.geoviewer.events.RemovedLayerEvent;
import nl.cloudfarming.client.logging.AppLogFactory;
import nl.cloudfarming.client.logging.AppLogger;
import nl.cloudfarming.client.model.Bean;
import nl.cloudfarming.client.model.Field;
import nl.cloudfarming.client.model.Shape;
import nl.cloudfarming.eventbus.BaseGuiEventProducer;
import nl.cloudfarming.eventbus.GuiEvent;
import nl.cloudfarming.eventbus.GuiEventKey;
import org.jdesktop.swingx.JXPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class SaveImportLayerAction
extends EditLayerAction {
    private Dialog dlg;
    private ImportLayer layer;
    private static final String SAVE_IMPORT_LAYER_DIALOG_TITLE = NbBundle.getMessage(AreaFieldModule.class, (String)"action.save_import_layer.dialog.title");
    private static final String SAVE_IMPORT_LAYER_ACTION = NbBundle.getMessage(AreaFieldModule.class, (String)"action.save_import_layer.dialog.action_name");
    private static final String SAVE_IMPORT_LAYER_DIALOG_OK = NbBundle.getMessage(AreaFieldModule.class, (String)"action.save_import_layer.dialog.button.ok");
    private static final String SAVE_IMPORT_LAYER_DIALOG_CANCEL = NbBundle.getMessage(AreaFieldModule.class, (String)"action.save_import_layer.dialog.button.cancel");
    private static final String SAVE_IMPORT_LAYER_DIALOG_TEXT = NbBundle.getMessage(AreaFieldModule.class, (String)"action.save_import_layer.dialog.text");
    private static final String SAVE_IMPORT_LAYER_LOG_FINISHED_SUCCESS = NbBundle.getMessage(AreaFieldModule.class, (String)"action.save_import_layer.loginfo.finished_success");
    private static final AppLogger LOG = AppLogFactory.getLogger(AreaFieldModule.class);
    private AreaService areaService;

    public void setAreaService(AreaService areaService) {
        this.areaService = areaService;
    }

    public AreaService getAreaService() {
        if (this.areaService == null) {
            this.areaService = new FieldAreaService();
        }
        return this.areaService;
    }

    public SaveImportLayerAction() {
        this.putValue("Name", SAVE_IMPORT_LAYER_ACTION);
    }

    public void saveImportLayer() {
        assert (this.layer != null);
        if (!(this.layer instanceof ImportLayer)) {
            return;
        }
        EnumMap<Shape.ShapeType, Integer> totals = new EnumMap<Shape.ShapeType, Integer>(Shape.ShapeType.class);
        for (Shape.ShapeType t : Shape.ShapeType.values()) {
            totals.put(t, 0);
        }
        ImportLayer importLayer = this.layer;
        List shapeLayerObjects = importLayer.getObjects();
        for (ShapeLayerObject shapeLayerObject : shapeLayerObjects) {
            Shape shape = shapeLayerObject.getObject();
            Bean bean = this.parseShape(shape);
            if (bean == null) continue;
            totals.put(shape.getType(), (Integer)totals.get(shape.getType()) + 1);
            if (!(bean instanceof Field)) continue;
            this.getAreaService().createNewField((Field)bean);
        }
        RemovedLayerEvent event = new RemovedLayerEvent((Layer)importLayer);
        new LayerEventProducer().triggerEvent((GuiEvent)event);
        new AreaEventProducer().triggerEvent(new GuiEvent(){

            public GuiEventKey getKey() {
                return AreaEventKey.FIELDS_IMPORTED;
            }

            public Object getContent() {
                return null;
            }
        });
        for (Shape.ShapeType shapeType : totals.keySet()) {
            if ((Integer)totals.get(shapeType) <= 0) continue;
            LOG.info(NbBundle.getMessage(AreaFieldModule.class, (String)"action.save_import_layer.loginfo.amount", totals.get(shapeType), (Object)shapeType.toString()));
        }
        LOG.info(SAVE_IMPORT_LAYER_LOG_FINISHED_SUCCESS);
    }

    private Bean parseShape(Shape shape) {
        if (shape == null || shape.getType() == null || shape.getGeometry() == null) {
            return null;
        }
        switch (shape.getType()) {
            case FIELD: {
                return new Field.Builder().setWKT(shape.getGeometry().toText()).setName(shape.getName()).setAcreage(Double.valueOf(shape.getGeometry().getArea())).build();
            }
        }
        return null;
    }

    private JButton getOkButton() {
        JButton jButtonOK = new JButton();
        jButtonOK.setText(SAVE_IMPORT_LAYER_DIALOG_OK);
        jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SaveImportLayerAction.this.dlg.setVisible(false);
                SaveImportLayerAction.this.saveImportLayer();
            }
        });
        return jButtonOK;
    }

    private JButton getCancelButton() {
        JButton jButtonCancel = new JButton();
        jButtonCancel.setText(SAVE_IMPORT_LAYER_DIALOG_CANCEL);
        jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SaveImportLayerAction.this.dlg.setVisible(false);
            }
        });
        return jButtonCancel;
    }

    public void actionPerformed(ActionEvent e) {
        this.layer = (ImportLayer)((Object)Utilities.actionsGlobalContext().lookup(ImportLayer.class));
        assert (this.layer != null);
        EnumMap<Shape.ShapeType, Integer> totals = new EnumMap<Shape.ShapeType, Integer>(Shape.ShapeType.class);
        int empty = 0;
        for (Shape.ShapeType t : Shape.ShapeType.values()) {
            totals.put(t, 0);
        }
        for (ShapeLayerObject layerObject : this.layer.getObjects()) {
            Shape.ShapeType st = layerObject.getObject().getType();
            if (st != null) {
                totals.put(st, (Integer)totals.get(st) + 1);
                continue;
            }
            ++empty;
        }
        JXPanel panel = new JXPanel((LayoutManager)new MigLayout("wrap 2"));
        panel.add((Component)new JLabel(SAVE_IMPORT_LAYER_DIALOG_TEXT), (Object)"wrap");
        for (Shape.ShapeType st : totals.keySet()) {
            if ((Integer)totals.get(st) <= 0) continue;
            panel.add((Component)new JLabel(st.toString() + " :"));
            panel.add((Component)new JLabel(totals.get(st) + ""));
        }
        if (empty > 0) {
            panel.add((Component)new JLabel("empty :"));
            panel.add((Component)new JLabel(empty + ""));
        }
        DialogDescriptor dd = new DialogDescriptor((Object)panel, SAVE_IMPORT_LAYER_DIALOG_TITLE);
        dd.setOptions(new Object[]{this.getOkButton(), this.getCancelButton()});
        this.dlg = DialogDisplayer.getDefault().createDialog(dd);
        this.dlg.setVisible(true);
    }

    private class LayerEventProducer
    extends BaseGuiEventProducer {
        public LayerEventProducer() {
            super(LayerEventKey.class);
        }
    }

    private class AreaEventProducer
    extends BaseGuiEventProducer {
        public AreaEventProducer() {
            super(AreaEventKey.class);
        }
    }
}

