/*
 * Decompiled with CFR 0.152.
 */
package nl.cloudfarming.client.area.field.shape;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import nl.cloudfarming.client.area.field.AreaFieldModule;
import nl.cloudfarming.client.area.field.shape.ImportLayer;
import nl.cloudfarming.client.area.field.shape.ShapeLayerObject;
import nl.cloudfarming.client.geoviewer.Layer;
import nl.cloudfarming.client.geoviewer.LayerAction;
import nl.cloudfarming.client.model.Shape;
import org.jdesktop.swingx.JXPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class MarkAllShapesAsAction
extends LayerAction {
    private Dialog dlg;
    private Layer layer;
    private final JComboBox comboBox = new JComboBox<Shape.ShapeType>(Shape.ShapeType.values());

    public MarkAllShapesAsAction() {
        this.putValue("Name", NbBundle.getMessage(AreaFieldModule.class, (String)"action.mark_all_shapes_as.name"));
    }

    public void actionPerformed(ActionEvent e) {
        this.layer = (Layer)Utilities.actionsGlobalContext().lookup(Layer.class);
        assert (this.layer != null);
        JXPanel panel = new JXPanel((LayoutManager)new MigLayout("wrap 2"));
        panel.add((Component)new JLabel(NbBundle.getMessage(AreaFieldModule.class, (String)"action.mark_all_shapes_as.dialog.label.choose_shape")));
        panel.add((Component)this.comboBox);
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(AreaFieldModule.class, (String)"action.mark_all_shapes_as.dialog.title"));
        dd.setOptions(new Object[]{this.getOkButton(), this.getCancelButton()});
        this.dlg = DialogDisplayer.getDefault().createDialog(dd);
        this.dlg.setVisible(true);
    }

    private JButton getOkButton() {
        JButton jButtonOK = new JButton();
        jButtonOK.setText(NbBundle.getMessage(AreaFieldModule.class, (String)"action.mark_all_shapes_as.dialog.button.ok"));
        jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MarkAllShapesAsAction.this.dlg.setVisible(false);
                if (MarkAllShapesAsAction.this.comboBox.getSelectedItem() != null) {
                    if (MarkAllShapesAsAction.this.layer instanceof ImportLayer) {
                        ImportLayer importLayer = (ImportLayer)MarkAllShapesAsAction.this.layer;
                        for (ShapeLayerObject layerObject : importLayer.getObjects()) {
                            layerObject.getObject().setType((Shape.ShapeType)MarkAllShapesAsAction.this.comboBox.getSelectedItem());
                        }
                    } else {
                        throw new IllegalStateException("MarkAllShapesAsAction is only applicable to ImportLayers ");
                    }
                }
            }
        });
        return jButtonOK;
    }

    private JButton getCancelButton() {
        JButton jButtonCancel = new JButton();
        jButtonCancel.setText(NbBundle.getMessage(AreaFieldModule.class, (String)"action.mark_all_shapes_as.dialog.button.cancel"));
        jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MarkAllShapesAsAction.this.dlg.setVisible(false);
            }
        });
        return jButtonCancel;
    }
}

