/*
 * Decompiled with CFR 0.152.
 */
package nl.cloudfarming.client.area.field.shape;

import java.beans.IntrospectionException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.ActionMap;
import nl.cloudfarming.client.area.field.shape.ImportLayer;
import nl.cloudfarming.client.area.field.shape.ShapeLayerObject;
import nl.cloudfarming.client.area.field.shape.ShapeNode;
import nl.cloudfarming.client.geoviewer.Layer;
import nl.cloudfarming.client.model.Bean;
import nl.cloudfarming.client.model.CommonModelService;
import nl.cloudfarming.client.model.DataProvider;
import nl.cloudfarming.client.model.FieldFile;
import nl.cloudfarming.client.model.Shape;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public class ImportDataProvider
extends CommonModelService {
    private final FieldFile plotFile;
    private ImportLayer importLayer;
    private final ShapeNodeKeys keys = new ShapeNodeKeys(this);
    private final Map<Shape, ShapeLayerObject> shapes = new HashMap<Shape, ShapeLayerObject>();

    public ImportDataProvider(FieldFile plotFile) {
        this.plotFile = plotFile;
        this.importLayer = new ImportLayer(plotFile, this);
        this.initExplorer();
    }

    protected final void initExplorer() {
        ExplorerManager manager = new ExplorerManager();
        this.setExplorerManager(manager, new ActionMap());
        this.getExplorerManager().setRootContext((Node)new AbstractNode((Children)this.keys));
        this.keys.addNotify();
    }

    protected String getModuleName() {
        return "area-field";
    }

    public void save(Bean bean) {
    }

    public ImportLayer getLayer() {
        return this.importLayer;
    }

    public Set<Shape> getShapes() {
        return Collections.unmodifiableSet(this.shapes.keySet());
    }

    public void addShape(Shape shape) {
        ShapeLayerObject layerObject = new ShapeLayerObject(shape);
        this.shapes.put(shape, layerObject);
        this.importLayer.addObject(layerObject);
    }

    class ShapeNodeKeys
    extends Children.Keys<Shape> {
        private final ImportDataProvider provider;

        public ShapeNodeKeys(ImportDataProvider provider) {
            super(false);
            this.provider = provider;
        }

        protected void addNotify() {
            this.setKeys(ImportDataProvider.this.getShapes());
        }

        protected Node[] createNodes(Shape shape) {
            try {
                return new Node[]{new ShapeNode((Layer)ImportDataProvider.this.importLayer, (ShapeLayerObject)ImportDataProvider.this.shapes.get(shape), (DataProvider)this.provider)};
            }
            catch (IntrospectionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }
    }
}

