/*
 * Decompiled with CFR 0.152.
 */
package nl.cloudfarming.client.area.field;

import java.beans.IntrospectionException;
import java.util.Date;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.swing.ActionMap;
import nl.cloudfarming.client.area.AreaService;
import nl.cloudfarming.client.area.field.FieldLayer;
import nl.cloudfarming.client.area.field.explorer.FieldRootNode;
import nl.cloudfarming.client.model.CommonModelService;
import nl.cloudfarming.client.model.DataProvider;
import nl.cloudfarming.client.model.Field;
import nl.cloudfarming.client.model.FieldFile;
import nl.cloudfarming.client.model.PartField;
import nl.cloudfarming.client.model.Persistable;
import nl.cloudfarming.client.model.ProductionUnit;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class FieldAreaService
extends CommonModelService
implements AreaService {
    protected final String getModuleName() {
        return "area-field";
    }

    public final List<Field> findAllCurrentFields() {
        this.startTransaction();
        Query query = this.getEntityManager().createNamedQuery("findAllValidFields");
        query.setParameter("date", (Object)new Date());
        return query.getResultList();
    }

    public final void createNewField(Field field) {
        this.persistInTransaction((Persistable)field);
    }

    public final void saveFieldChanges(Field field) {
        this.mergeAndPersistInTransaction((Persistable)field);
    }

    public final void createNewFieldFile(FieldFile fieldFile) {
        this.persistInTransaction((Persistable)fieldFile);
    }

    public List<ProductionUnit> findProductionUnitsByDate(Date date) {
        this.startTransaction();
        Query query = this.getEntityManager().createNamedQuery("findAllProductionUnitsByDate");
        query.setParameter("date", (Object)date);
        return query.getResultList();
    }

    protected final void initExplorer() {
        try {
            ExplorerManager manager = new ExplorerManager();
            manager.setRootContext((Node)new FieldRootNode(new FieldLayer("service.explorer.layerlist.field_node.name", (DataProvider)this)));
            manager.getRootContext().setDisplayName(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"service.explorer.rootnode.displayname"));
            ActionMap map = new ActionMap();
            map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)manager));
            map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)manager));
            map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)manager));
            map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)manager, (boolean)true));
            this.setExplorerManager(manager, map);
        }
        catch (IntrospectionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public List<PartField> findPartFieldsByDate(Date date) {
        this.startTransaction();
        Query query = this.getEntityManager().createNamedQuery("findAllPartFieldsByDate");
        query.setParameter("date", (Object)date);
        return query.getResultList();
    }

    public FieldFile findFieldFileByNameAndChecksum(String name, String checksum) {
        this.startTransaction();
        Query query = this.getEntityManager().createNamedQuery("findFieldFileByNamAndChecksum");
        query.setParameter("fileName", (Object)name);
        query.setParameter("checksum", (Object)checksum);
        try {
            return (FieldFile)query.getSingleResult();
        }
        catch (NoResultException ner) {
            return null;
        }
    }

    public Field findFieldById(long id) {
        this.startTransaction();
        return (Field)this.getEntityManager().find(Field.class, (Object)id);
    }
}

