/**
 * Copyright (C) 2010 Cloudfarming <info@cloudfarming.nl>
 *
 * Licensed under the Eclipse Public License - v 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.eclipse.org/legal/epl-v10.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package nl.cloudfarming.client.area.field.shape;

import com.vividsolutions.jts.geom.Geometry;
import nl.cloudfarming.client.model.Shape;
import nl.cloudfarming.client.geoviewer.LayerObject;
import nl.cloudfarming.client.geoviewer.LayerObjectAction;

/**
 *
 * @author Timon Veenstra
 */
public class ShapeLayerObject implements LayerObject<Geometry, Shape> {

    private final Shape shape;

    public ShapeLayerObject(Shape shape) {
        this.shape = shape;
    }

    @Override
    public Shape getObject() {
        return this.shape;
    }

    @Override
    public Geometry getGeometry() {
        return this.shape.getGeometry();
    }

    @Override
    public String getKey() {
        return Long.toString(this.shape.getId());
    }

    @Override
    public Object getKeyAttributeValue() {
        return shape.getName();
    }

    @Override
    public String getTooltipText() {
        return Long.toString(this.shape.getId()) + " " + this.shape.getName();
    }

    @Override
    public Long getId() {
        return this.shape.getId();
    }

    @Override
    public LayerObjectAction[] getActions() {
        return null;
    }

    /**
     * Shapes should not be persisted.
     * Therefore Shape.java does not implement persistable and LayerObjectNode will not add the savecookie to the explorerDataProvider.
     * This save method should never be actually called.
     */
    @Override
    public void save() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}
