/**
 * Copyright (C) 2010 Cloudfarming <info@cloudfarming.nl>
 *
 * Licensed under the Eclipse Public License - v 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.eclipse.org/legal/epl-v10.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package nl.cloudfarming.client.area.field.shape;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import nl.cloudfarming.client.area.field.FieldPalette;
import nl.cloudfarming.client.geoviewer.Category;
import nl.cloudfarming.client.geoviewer.LayerAction;
import nl.cloudfarming.client.geoviewer.ObjectLayer;
import nl.cloudfarming.client.model.FieldFile;
import org.openide.explorer.ExplorerManager;

/**
 * The importLayer containes shapes from an imported shapefile.
 * The layername is based on the filename of the imported shapefile and so it
 * is intended that each imported shapefile gets placed on a separate layer.
 *
 * The importlayer defines actions for (for example but not exclusive) saving the shapes to
 * more permanent layers.
 *
 * @author Timon Veenstra
 */
public class ImportLayer extends ObjectLayer<ShapeLayerObject> {

    private final FieldFile fieldFile;

    public ImportLayer(final FieldFile fieldFile, final ImportDataProvider dataProvider) {
        super(new FieldPalette(), Category.AREA, fieldFile.getFileName(), dataProvider, true);
        this.fieldFile = fieldFile;
    }

    /**
     * Return the fieldFile represented by this importlayer
     * @return The fieldFile represented by this importlayer
     */
    final public FieldFile getFieldFile() {
        return fieldFile;
    }

    @Override
    public LayerAction[] getActions() {
        return new LayerAction[]{new SaveImportLayerAction(), new MarkAllShapesAsAction()};
    }
    
}
