/**
 * Copyright (C) 2010 Cloudfarming <info@cloudfarming.nl>
 *
 * Licensed under the Eclipse Public License - v 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.eclipse.org/legal/epl-v10.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package nl.cloudfarming.client.area.field.shape;

import java.beans.IntrospectionException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.ActionMap;
import nl.cloudfarming.client.area.field.AreaFieldModule;
import nl.cloudfarming.client.model.Bean;
import nl.cloudfarming.client.model.CommonModelService;
import nl.cloudfarming.client.model.FieldFile;
import nl.cloudfarming.client.model.Shape;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

/**
 *
 * @author Timon Veenstra
 */
public class ImportDataProvider extends CommonModelService {

    private final FieldFile plotFile;
    private ImportLayer importLayer;
//    ShapeNodeFactory shapeNodeFactory = new ShapeNodeFactory(importLayer);
    private final ShapeNodeKeys keys = new ShapeNodeKeys(this);
    private final Map<Shape, ShapeLayerObject> shapes = new HashMap<Shape, ShapeLayerObject>();

    public ImportDataProvider(FieldFile plotFile) {
        this.plotFile = plotFile;
        importLayer = new ImportLayer(plotFile, this);
        initExplorer();
    }

    @Override
    protected final void initExplorer() {
        ExplorerManager manager = new ExplorerManager();
        setExplorerManager(manager, new ActionMap());
        getExplorerManager().setRootContext(new AbstractNode(keys));
        keys.addNotify();
    }

    @Override
    protected String getModuleName() {
        return AreaFieldModule.MODULE_NAME;
    }

    @Override
    public void save(Bean bean) {
        // shape objects cannot be persisted
    }

    /**
     * get the import layer containing the imported shapes
     * 
     * @return import layer
     */
    public ImportLayer getLayer() {
        return importLayer;
    }

    /**
     * get the list with managed shapes
     * @return
     */
    public Set<Shape> getShapes() {
        return Collections.unmodifiableSet(shapes.keySet());
    }

    /**
     * add a shape to the list of managed shapes
     * 
     * @param shape
     */
    public void addShape(Shape shape) {
        ShapeLayerObject layerObject = new ShapeLayerObject(shape);
        shapes.put(shape, layerObject);
        importLayer.addObject(layerObject);
    }

    class ShapeNodeKeys extends Children.Keys<Shape> {

        private final ImportDataProvider provider;

        public ShapeNodeKeys(ImportDataProvider provider) {
            super(false);
            this.provider = provider;

        }

        @Override
        protected void addNotify() {
            setKeys(getShapes());
        }

        @Override
        protected Node[] createNodes(Shape shape) {
            try {
                return new Node[]{new ShapeNode(importLayer, shapes.get(shape), provider)};
            } catch (IntrospectionException ex) {
                Exceptions.printStackTrace(ex);
                return null;
            }
        }
    }
}
