/**
 * Copyright (C) 2010 Cloudfarming <info@cloudfarming.nl>
 *
 * Licensed under the Eclipse Public License - v 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.eclipse.org/legal/epl-v10.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package nl.cloudfarming.client.area.field.pref;

import org.openide.util.NbPreferences;

/**
 * utility enum for storing and retrieving preferences
 * ( for localized text use NbBundle )
 *
 * @author Timon Veenstra
 */
//TODO get defaults from filtered resource
public enum AreaFieldPreference {

    LOAD_DIR("loadDir", "data/load"),
    SHAPE_FILE_ARCHIVE_DIR("areafieldpreferences.shape.archive.relative_path", "data/shape"),
    FIELD_DATABASE_DIR("areafieldpreferences.database.dir", "data/db/area-field"),
    LAST_SHAPE_DIR("chooser.shape.last.dir", ""),
    SHAPE_CONTAINTS_FIELD("field.options.shape.contains.field", "true"),
    SHAPE_CONTAINTS_PARTFIELD("field.options.shape.contains.partfield", "false"),
    SHAPE_ATT_POLYGON("field.options.shape.att.polygon", "the_geom"),
    SHAPE_ATT_NAME("field.options.shape.att.name", "KAVEL");


    private String propertyName;
    private String defaultProperty;

    private AreaFieldPreference(String propertyName, String defaultProperty) {
        this.propertyName = propertyName;
        this.defaultProperty = defaultProperty;
    }

    public String getDefaultProperty() {
        return defaultProperty;
    }

    public String getPropertyName() {
        return propertyName;
    }

    public String getValue() {
        return NbPreferences.forModule(this.getClass()).get(propertyName, defaultProperty);
    }

    public void saveValue(String value) {
        NbPreferences.forModule(this.getClass()).put(propertyName, value);
    }
}
