/**
 * Copyright (C) 2010 Cloudfarming <info@cloudfarming.nl>
 *
 * Licensed under the Eclipse Public License - v 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.eclipse.org/legal/epl-v10.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package nl.cloudfarming.client.area.field;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import nl.cloudfarming.client.geoviewer.Layer;
import nl.cloudfarming.client.geoviewer.LayerObject;
import nl.cloudfarming.client.geoviewer.MapController;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/**
 * Action to select a field on the map
 * 
 * @author Timon Veenstra
 */
public class SelectFieldInMapAction implements ContextAwareAction {

    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final Map<String, Object> content = new HashMap<String, Object>();
    private Lookup actionContext;

    public SelectFieldInMapAction() {
        content.put("menuText", NbBundle.getMessage(this.getClass(), "action.select_plot_in_map.name"));
    }

    /**
     *
     * @param e
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        LayerObject layerObject = actionContext.lookup(LayerObject.class);
        Layer layer = actionContext.lookup(Layer.class);
        MapController mapApi = MapController.Registry.getLookup().lookup(MapController.class);
        assert mapApi != null;
        assert layer != null;
        assert layer != layerObject;
        mapApi.zoomToObject(layerObject, layer);
    }

    @Override
    public Object getValue(String key) {
        return content.get(key);
    }

    @Override
    public void putValue(String key, Object value) {
        content.put(key, value);
    }

    @Override
    public void setEnabled(boolean b) {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    @Override
    public Action createContextAwareInstance(Lookup actionContext) {
        this.actionContext = actionContext;
        return this;
    }
}
