/**
 * Copyright (C) 2010 Cloudfarming <info@cloudfarming.nl>
 *
 * Licensed under the Eclipse Public License - v 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.eclipse.org/legal/epl-v10.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package nl.cloudfarming.client.area.field;

import com.vividsolutions.jts.geom.MultiPolygon;
import nl.cloudfarming.client.area.AreaService;
import nl.cloudfarming.client.geoviewer.LayerObject;
import nl.cloudfarming.client.geoviewer.LayerObjectAction;
import nl.cloudfarming.client.model.ProductionUnit;

/**
 * Layer object that represents the specified productionUnit-object
 * 
 * @author Gerben Feenstra
 */
public class ProductionUnitLayerObject implements LayerObject<MultiPolygon, ProductionUnit> {

    /**
     * The productionUnit this ProductionUnitLayerObject represents
     */
    private final ProductionUnit productionUnit;
    
    /**
     * AreaService this ProductionUnitLayerObject should use for persistence
     */
    private AreaService service;

    public ProductionUnitLayerObject(final ProductionUnit productionUnit) {
        this.productionUnit = productionUnit;
    }

    @Override
    public String getKey() {
        return Long.toString(this.productionUnit.getId());
    }

    @Override
    public String getTooltipText() {
        return Long.toString(this.productionUnit.getId()) + " " + this.productionUnit.getName();
    }

    @Override
    public Long getKeyAttributeValue() {
        return this.productionUnit.getId();
    }

    @Override
    public Long getId() {
        return this.productionUnit.getId();
    }

    @Override
    public ProductionUnit getObject() {
        return this.productionUnit;
    }

    @Override
    public LayerObjectAction[] getActions() {
        return null;
    }

    @Override
    public void save() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public MultiPolygon getGeometry() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
    
    final protected AreaService getFieldAreaService() {
        return service == null ? new FieldAreaService() : service;
    }

    final protected void setFieldAreaService(final FieldAreaService service) {
       this.service = service;
    }

}
