/**
 * Copyright (C) 2010 Cloudfarming <info@cloudfarming.nl>
 *
 * Licensed under the Eclipse Public License - v 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.eclipse.org/legal/epl-v10.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package nl.cloudfarming.client.area.field;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import nl.cloudfarming.client.area.AreaService;
import nl.cloudfarming.client.geoviewer.Category;
import nl.cloudfarming.client.geoviewer.ObjectLayer;
import nl.cloudfarming.client.model.ProductionUnit;
import nl.cloudfarming.client.model.DataProvider;

/**
 * A layer for Production units of a specific year
 * 
 * @author Gerben Feenstra
 */
public class ProductionUnitLayer extends ObjectLayer<ProductionUnitLayerObject> {

    /**
     * The date of this Production units layer. Only Production units with the same date (year) will be shown in this layer
     */
    private final Date date;
    
    public ProductionUnitLayer(final String nodeName, final Date date, final DataProvider dp) {
        super(new FieldPalette(), Category.AREA, nodeName, dp,true);
        this.date = date;
        if (getObjects().size() > 0) {
            clearObjects();
        }

        List<ProductionUnitLayerObject> objects = new ArrayList<ProductionUnitLayerObject>();

        AreaService areaService = new FieldAreaService();
        for (ProductionUnit productionUnit : areaService.findProductionUnitsByDate(this.date)) {
            objects.add(new ProductionUnitLayerObject(productionUnit));
        }
        addObjects(objects);
    }
}
