/*
 * Decompiled with CFR 0.152.
 */
package nl.cloudfarming.client.area.field.shape;

import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import nl.cloudfarming.client.area.field.AreaFieldModule;
import nl.cloudfarming.client.area.field.ParseWKTException;
import nl.cloudfarming.client.area.field.pref.AreaFieldPreference;
import nl.cloudfarming.client.area.field.shape.ImportDataProvider;
import nl.cloudfarming.client.area.field.shape.Shape;
import nl.cloudfarming.client.geoviewer.event.GeoEvent;
import nl.cloudfarming.client.logging.AppLogFactory;
import nl.cloudfarming.client.logging.AppLogger;
import nl.cloudfarming.client.model.ShapeFile;
import nl.cloudfarming.client.util.MD5Sum;
import nl.cloudfarming.client.util.NotAFileException;
import nl.cloudfarming.eventbus.GuiEventKey;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.openide.util.NbBundle;

public class ShapeFileProcessor {
    private static final String LOGKEY_PROCESSING_SUMMARY_PROCESSEDMSG = "shape.fileprocessor.loginfo.process_end";
    private static final String LOGKEY_PROCESSING_START = "shape.fileprocessor.loginfo.process_start";
    private static final String LOGKEY_PROCESSING_PARSE_ERROR = "shape.fileprocessor.logerror.process_error";
    private final File shapeFile;
    private static final AppLogger LOG = AppLogFactory.getLogger(AreaFieldModule.class);
    private static final String DEFAULT_SHAPE_NAME = NbBundle.getMessage(AreaFieldModule.class, (String)"shape.fileprocessor.default_shape_name");

    public ShapeFileProcessor(File shapeFile) {
        this.shapeFile = shapeFile;
    }

    public void process() throws NotAFileException {
        ShapefileDataStore shpDataStore = null;
        if (this.shapeFile.isFile()) {
            try {
                LOG.info(LOGKEY_PROCESSING_START, new Object[]{this.shapeFile.getName()});
                String checkSum = MD5Sum.getHex((byte[])MD5Sum.createChecksum((InputStream)new FileInputStream(this.shapeFile)));
                ShapeFile plotFile = new ShapeFile();
                plotFile.setChecksum(checkSum);
                plotFile.setFileCreated(new Date(this.shapeFile.lastModified()));
                plotFile.setFileName(this.shapeFile.getName());
                plotFile.setFileRead(new Date());
                ImportDataProvider importDataProvider = new ImportDataProvider(plotFile);
                shpDataStore = new ShapefileDataStore(this.shapeFile.toURI().toURL());
                String typeName = shpDataStore.getTypeNames()[0];
                SimpleFeatureSource featureSource = shpDataStore.getFeatureSource(typeName);
                FeatureCollection result = featureSource.getFeatures();
                FeatureIterator iterator = result.features();
                while (iterator.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)iterator.next();
                    Shape shape = this.parseShape(feature);
                    importDataProvider.addShape(shape);
                }
                iterator.close();
                LOG.info(LOGKEY_PROCESSING_SUMMARY_PROCESSEDMSG, new Object[]{this.shapeFile.getName()});
                GeoEvent.getProducer().triggerEvent((GuiEventKey)GeoEvent.NEW_LAYER, (Object)importDataProvider.getLayerNode());
            }
            catch (NoSuchAlgorithmException ex) {
                StringBuilder exBuilder = new StringBuilder("No such algorithmException ");
                exBuilder.append(this.shapeFile.getName());
                LOG.error(exBuilder.toString(), (Throwable)ex);
            }
            catch (IOException ex) {
                StringBuilder exBuilder = new StringBuilder("IOException while reading ");
                exBuilder.append(this.shapeFile.getName());
                LOG.error(exBuilder.toString(), (Throwable)ex);
            }
        } else {
            StringBuilder sb = new StringBuilder("The File-object [");
            sb.append(this.shapeFile.getPath());
            sb.append("] passed to this ShapeFileProcessor instance is not a File");
            throw new NotAFileException(sb.toString());
        }
    }

    public Shape parseShape(SimpleFeature payload) throws ParseWKTException {
        int attIndexPlotPoly = payload.getFeatureType().indexOf(AreaFieldPreference.SHAPE_ATT_POLYGON.getValue());
        int attIndexPlotName = payload.getFeatureType().indexOf(AreaFieldPreference.SHAPE_ATT_NAME.getValue());
        Geometry geometry = null;
        if (attIndexPlotPoly >= 0) {
            geometry = (Geometry)payload.getAttribute(attIndexPlotPoly);
        }
        String shapeName = DEFAULT_SHAPE_NAME;
        if (attIndexPlotName >= 0) {
            shapeName = (String)payload.getAttribute(attIndexPlotName);
        }
        Shape shape = new Shape(geometry);
        shape.setName(shapeName);
        shape.setType(Shape.ShapeType.SKIP);
        return shape;
    }
}

