/*
 * Decompiled with CFR 0.152.
 */
package nl.cloudfarming.client.area.field.shape;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.filechooser.FileFilter;
import nl.cloudfarming.client.area.field.AreaFieldModule;
import nl.cloudfarming.client.area.field.pref.AreaFieldPreference;
import nl.cloudfarming.client.area.field.shape.ShapeFileProcessor;
import nl.cloudfarming.client.util.FileCopier;
import nl.cloudfarming.client.util.FilePickerUtil;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class ShapeFilePicker {
    private static String FILECHOOSER_DIR = NbBundle.getMessage(AreaFieldModule.class, (String)"shape.filepicker.chooser.directory");
    private static String FILECHOOSER_TITLE = NbBundle.getMessage(AreaFieldModule.class, (String)"shape.filepicker.title");
    private static String FILECHOOSER_APPROVE_TEXT = NbBundle.getMessage(AreaFieldModule.class, (String)"shape.filepicker.chooser.button.approve.text");
    private static final String USER_HOME = "user.dir";
    private boolean cancelled = false;
    private final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)"processing shape files", (Cancellable)new Cancellable(){

        public boolean cancel() {
            ShapeFilePicker.this.cancelled = true;
            ShapeFilePicker.this.progressHandle.finish();
            return ShapeFilePicker.this.cancelled;
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show() {
        File selectedFileOrDir = this.showPicker();
        if (selectedFileOrDir == null) {
            return;
        }
        try {
            File destinationDir = this.getDestination();
            if (selectedFileOrDir.isDirectory()) {
                FileCopier.copyDirectory((File)selectedFileOrDir, (File)destinationDir, (String)".shp", (boolean)true);
                if (destinationDir.listFiles().length < 1) {
                    throw new FileNotFoundException("No files found in " + destinationDir.getAbsolutePath());
                }
                this.progressHandle.start(destinationDir.listFiles().length);
                for (File file : destinationDir.listFiles()) {
                    if (file.getName().toLowerCase().endsWith(".shp")) {
                        ShapeFileProcessor processor = new ShapeFileProcessor(file);
                        processor.process();
                        this.progressHandle.progress(file.getName() + " processed", 1);
                        continue;
                    }
                    this.progressHandle.progress(1);
                }
            } else if (selectedFileOrDir.getName().toLowerCase().endsWith(".shp")) {
                this.progressHandle.start(1);
                FileCopier.copyFile((File)selectedFileOrDir, (File)destinationDir, (boolean)true);
                File shapeFileToProcess = new File(destinationDir.getPath() + File.separator + selectedFileOrDir.getName());
                ShapeFileProcessor processor = new ShapeFileProcessor(shapeFileToProcess);
                processor.process();
                this.progressHandle.progress(destinationDir.getName() + " processed", 1);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            this.progressHandle.finish();
        }
    }

    private File showPicker() {
        String name = AreaFieldPreference.LAST_SHAPE_DIR.getValue();
        File userHome = name.equals("") ? new File(System.getProperty(USER_HOME)) : new File(name);
        ArrayList<String> supportedExtensions = new ArrayList<String>();
        supportedExtensions.add(".shp");
        FileFilter ff = FilePickerUtil.createSwingFileFilter(supportedExtensions, (String)"Shape file (*.shp)");
        FileChooserBuilder fcb = new FileChooserBuilder(FILECHOOSER_DIR);
        fcb.setTitle(FILECHOOSER_TITLE);
        fcb.setDefaultWorkingDirectory(userHome);
        fcb.addFileFilter(ff);
        fcb.setApproveText(FILECHOOSER_APPROVE_TEXT);
        File file = fcb.showOpenDialog();
        if (file != null) {
            AreaFieldPreference.LAST_SHAPE_DIR.saveValue(file.getPath());
        }
        return file;
    }

    private File getDestination() {
        StringBuilder sb = new StringBuilder(NbPreferences.root().get(USER_HOME, System.getProperty(USER_HOME)));
        sb.append("/");
        sb.append(AreaFieldPreference.SHAPE_FILE_ARCHIVE_DIR.getValue());
        String appDir = sb.toString();
        return new File(appDir);
    }
}

