/*
 * Decompiled with CFR 0.152.
 */
package nl.cloudfarming.client.area.field.shape;

import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import nl.cloudfarming.client.area.AreaEvent;
import nl.cloudfarming.client.area.AreaService;
import nl.cloudfarming.client.area.field.AreaFieldModule;
import nl.cloudfarming.client.area.field.FieldAreaService;
import nl.cloudfarming.client.area.field.shape.ImportDataProvider;
import nl.cloudfarming.client.area.field.shape.Shape;
import nl.cloudfarming.client.geoviewer.Layer;
import nl.cloudfarming.client.geoviewer.LayerAction;
import nl.cloudfarming.client.geoviewer.event.GeoEvent;
import nl.cloudfarming.client.logging.AppLogFactory;
import nl.cloudfarming.client.logging.AppLogger;
import nl.cloudfarming.eventbus.GuiEventKey;
import org.jdesktop.swingx.JXPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class SaveImportLayerAction
extends LayerAction {
    private Dialog dlg;
    private static final String SAVE_IMPORT_LAYER_DIALOG_TITLE = NbBundle.getMessage(AreaFieldModule.class, (String)"action.save_import_layer.dialog.title");
    private static final String SAVE_IMPORT_LAYER_ACTION = NbBundle.getMessage(AreaFieldModule.class, (String)"action.save_import_layer.dialog.action_name");
    private static final String SAVE_IMPORT_LAYER_DIALOG_OK = NbBundle.getMessage(AreaFieldModule.class, (String)"action.save_import_layer.dialog.button.ok");
    private static final String SAVE_IMPORT_LAYER_DIALOG_CANCEL = NbBundle.getMessage(AreaFieldModule.class, (String)"action.save_import_layer.dialog.button.cancel");
    private static final String SAVE_IMPORT_LAYER_DIALOG_TEXT = NbBundle.getMessage(AreaFieldModule.class, (String)"action.save_import_layer.dialog.text");
    private static final String SAVE_IMPORT_LAYER_LOG_FINISHED_SUCCESS = NbBundle.getMessage(AreaFieldModule.class, (String)"action.save_import_layer.loginfo.finished_success");
    private static final AppLogger APPLOGGER = AppLogFactory.getLogger(AreaFieldModule.class);
    private static final Logger LOGGER = Logger.getLogger(SaveImportLayerAction.class.getName());
    private AreaService areaService = (AreaService)Lookup.getDefault().lookup(FieldAreaService.class);
    private final ImportDataProvider dataProvider;

    public void setAreaService(AreaService areaService) {
        this.areaService = areaService;
    }

    public SaveImportLayerAction(ImportDataProvider dataProvider) {
        this.putValue("Name", SAVE_IMPORT_LAYER_ACTION);
        this.dataProvider = dataProvider;
    }

    void saveImportLayer() {
        EnumMap<Shape.ShapeType, Integer> totals = new EnumMap<Shape.ShapeType, Integer>(Shape.ShapeType.class);
        int empty = 0;
        for (Shape.ShapeType t : Shape.ShapeType.values()) {
            totals.put(t, 0);
        }
        for (Shape shape : this.dataProvider.getShapes()) {
            if (shape == null || shape.getType() == null || shape.getGeometry() == null) {
                LOGGER.log(Level.WARNING, "Empty shape not parsable to Bean");
                ++empty;
                continue;
            }
            totals.put(shape.getType(), (Integer)totals.get((Object)shape.getType()) + 1);
            switch (shape.getType()) {
                case FIELD: {
                    assert (shape.getGeometry() instanceof MultiPolygon) : "Fields can only be created from MultiPolygons";
                    this.areaService.createNewField(shape.getName(), (MultiPolygon)shape.getGeometry(), "Name");
                    break;
                }
                case HELPLINE: {
                    assert (shape.getGeometry() instanceof MultiLineString) : "Fields can only be created from MultiLineStrings";
                    this.areaService.createNewHelpLine(shape.getName(), (MultiLineString)shape.getGeometry(), "Name");
                    break;
                }
            }
        }
        Layer layer = (Layer)Utilities.actionsGlobalContext().lookup(Layer.class);
        GeoEvent.getProducer().triggerEvent((GuiEventKey)GeoEvent.DISCARD_LAYER, (Object)layer);
        AreaEvent.getProducer().triggerEvent((GuiEventKey)AreaEvent.IMPORT_SAVED);
        for (Shape.ShapeType shapeType : totals.keySet()) {
            if ((Integer)totals.get((Object)shapeType) <= 0) continue;
            APPLOGGER.info(NbBundle.getMessage(AreaFieldModule.class, (String)"action.save_import_layer.loginfo.amount", totals.get((Object)shapeType), (Object)shapeType.toString()));
        }
        APPLOGGER.info(SAVE_IMPORT_LAYER_LOG_FINISHED_SUCCESS);
    }

    private JButton getOkButton() {
        JButton jButtonOK = new JButton();
        jButtonOK.setText(SAVE_IMPORT_LAYER_DIALOG_OK);
        jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SaveImportLayerAction.this.dlg.setVisible(false);
                SaveImportLayerAction.this.saveImportLayer();
            }
        });
        return jButtonOK;
    }

    private JButton getCancelButton() {
        JButton jButtonCancel = new JButton();
        jButtonCancel.setText(SAVE_IMPORT_LAYER_DIALOG_CANCEL);
        jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SaveImportLayerAction.this.dlg.setVisible(false);
            }
        });
        return jButtonCancel;
    }

    public void actionPerformed(ActionEvent e) {
        EnumMap<Shape.ShapeType, Integer> totals = new EnumMap<Shape.ShapeType, Integer>(Shape.ShapeType.class);
        int empty = 0;
        for (Shape.ShapeType t : Shape.ShapeType.values()) {
            totals.put(t, 0);
        }
        for (Shape shape : this.dataProvider.getShapes()) {
            Shape.ShapeType st = shape.getType();
            if (st != null) {
                totals.put(st, (Integer)totals.get((Object)st) + 1);
                continue;
            }
            ++empty;
        }
        JXPanel panel = new JXPanel((LayoutManager)new MigLayout("wrap 2"));
        panel.add((Component)new JLabel(SAVE_IMPORT_LAYER_DIALOG_TEXT), (Object)"wrap");
        for (Shape.ShapeType st : totals.keySet()) {
            if ((Integer)totals.get((Object)st) <= 0) continue;
            panel.add((Component)new JLabel(st.toString() + " :"));
            panel.add((Component)new JLabel(totals.get((Object)st) + ""));
        }
        if (empty > 0) {
            panel.add((Component)new JLabel("empty :"));
            panel.add((Component)new JLabel(empty + ""));
        }
        DialogDescriptor dd = new DialogDescriptor((Object)panel, SAVE_IMPORT_LAYER_DIALOG_TITLE);
        dd.setOptions(new Object[]{this.getOkButton(), this.getCancelButton()});
        this.dlg = DialogDisplayer.getDefault().createDialog(dd);
        this.dlg.setVisible(true);
    }
}

