/*
 * Decompiled with CFR 0.152.
 */
package nl.cloudfarming.client.area.field.shape;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import nl.cloudfarming.client.area.field.shape.ImportLayer;
import nl.cloudfarming.client.area.field.shape.Shape;
import nl.cloudfarming.client.model.CommonModelService;
import nl.cloudfarming.client.model.ShapeFile;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.lookup.Lookups;

public class ImportDataProvider
extends CommonModelService {
    private ImportLayer importLayer;
    private final ShapeNodeKeys keys = new ShapeNodeKeys();
    private final List<Shape> shapes = new ArrayList<Shape>();

    public ImportDataProvider(ShapeFile plotFile) {
        this.importLayer = new ImportLayer(plotFile, this);
    }

    protected final ExplorerManager initExplorer() {
        ExplorerManager manager = new ExplorerManager();
        manager.setRootContext((Node)new ShapeFileNode((Children)this.keys, this.importLayer));
        this.keys.addNotify();
        return manager;
    }

    public Node getLayerNode() {
        return this.getExplorerManager().getRootContext();
    }

    public List<Shape> getShapes() {
        return Collections.unmodifiableList(this.shapes);
    }

    public void addShape(Shape shape) {
        this.shapes.add(shape);
    }

    class ShapeNodeKeys
    extends Children.Keys<Shape> {
        public ShapeNodeKeys() {
            super(false);
        }

        protected void addNotify() {
            this.setKeys(ImportDataProvider.this.getShapes());
        }

        protected Node[] createNodes(Shape shape) {
            return new Node[]{new AbstractNode(Children.LEAF, Lookups.fixed((Object[])new Object[]{shape}))};
        }
    }

    class ShapeFileNode
    extends AbstractNode {
        public ShapeFileNode(Children children, ImportLayer importLayer) {
            super(children, Lookups.fixed((Object[])new Object[]{importLayer}));
            this.setDisplayName(importLayer.getName());
        }

        public Action[] getActions(boolean context) {
            return ImportDataProvider.this.importLayer.getActions();
        }
    }
}

