/*
 * Decompiled with CFR 0.152.
 */
package nl.cloudfarming.client.area.field.explorer;

import java.beans.IntrospectionException;
import java.util.List;
import nl.cloudfarming.client.area.AreaEvent;
import nl.cloudfarming.client.area.AreaService;
import nl.cloudfarming.client.area.field.AreaFieldModule;
import nl.cloudfarming.client.area.field.FieldAreaService;
import nl.cloudfarming.client.area.field.explorer.HelpLineNode;
import nl.cloudfarming.client.model.HelpLine;
import nl.cloudfarming.eventbus.GuiEvent;
import nl.cloudfarming.eventbus.GuiEventBus;
import nl.cloudfarming.eventbus.GuiEventKey;
import nl.cloudfarming.eventbus.GuiEventListener;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class HelpLineNodeFactory
extends ChildFactory<HelpLine> {
    private AreaService service;

    public HelpLineNodeFactory() {
        GuiEventBus.addListener((GuiEventListener)new GuiEventListener(){

            public void onEvent(GuiEvent event) {
                HelpLineNodeFactory.this.refresh(true);
            }

            public boolean listensTo(GuiEventKey guiEventKey) {
                return guiEventKey.equals(AreaEvent.IMPORT_SAVED) || guiEventKey.equals(AreaEvent.HELP_LINE_REMOVED);
            }

            public String getModuleName() {
                return AreaFieldModule.MODULE_NAME;
            }
        });
    }

    protected Node createNodeForKey(HelpLine key) {
        try {
            return new HelpLineNode(key, this.service);
        }
        catch (IntrospectionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    protected boolean createKeys(List<HelpLine> toPopulate) {
        toPopulate.addAll(this.getService().findAllHelpLines());
        return true;
    }

    public AreaService getService() {
        if (this.service == null) {
            this.service = (AreaService)Lookup.getDefault().lookup(AreaService.class);
        }
        return this.service;
    }

    public void setService(FieldAreaService service) {
        this.service = service;
    }
}

