/*
 * Decompiled with CFR 0.152.
 */
package nl.cloudfarming.client.area.field.explorer;

import java.beans.IntrospectionException;
import java.util.List;
import nl.cloudfarming.client.area.AreaEvent;
import nl.cloudfarming.client.area.AreaService;
import nl.cloudfarming.client.area.field.AreaFieldModule;
import nl.cloudfarming.client.area.field.explorer.FieldNode;
import nl.cloudfarming.client.model.Field;
import nl.cloudfarming.eventbus.GuiEvent;
import nl.cloudfarming.eventbus.GuiEventBus;
import nl.cloudfarming.eventbus.GuiEventKey;
import nl.cloudfarming.eventbus.GuiEventListener;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class FieldNodeFactory
extends ChildFactory<Field> {
    private AreaService service;

    public FieldNodeFactory() {
        GuiEventBus.addListener((GuiEventListener)new GuiEventListener(){

            public void onEvent(GuiEvent event) {
                FieldNodeFactory.this.refresh(true);
            }

            public boolean listensTo(GuiEventKey guiEventKey) {
                return guiEventKey.equals(AreaEvent.IMPORT_SAVED) || guiEventKey.equals(AreaEvent.FIELD_REMOVED);
            }

            public String getModuleName() {
                return AreaFieldModule.MODULE_NAME;
            }
        });
    }

    protected Node createNodeForKey(Field key) {
        try {
            return new FieldNode(key, this.getService());
        }
        catch (IntrospectionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    protected boolean createKeys(List<Field> toPopulate) {
        toPopulate.addAll(this.getService().findAllCurrentFields());
        return true;
    }

    public AreaService getService() {
        if (this.service == null) {
            this.service = (AreaService)Lookup.getDefault().lookup(AreaService.class);
        }
        return this.service;
    }

    public void setService(AreaService service) {
        this.service = service;
    }
}

