/*
 * Decompiled with CFR 0.152.
 */
package nl.cloudfarming.client.area.field;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import java.beans.IntrospectionException;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import nl.cloudfarming.client.area.AreaService;
import nl.cloudfarming.client.area.field.FieldLayer;
import nl.cloudfarming.client.area.field.HelpLineLayer;
import nl.cloudfarming.client.area.field.explorer.GeometryRootNode;
import nl.cloudfarming.client.geoviewer.Layer;
import nl.cloudfarming.client.model.CommonModelService;
import nl.cloudfarming.client.model.Field;
import nl.cloudfarming.client.model.HelpLine;
import nl.cloudfarming.client.util.GeometryUtil;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class FieldAreaService
extends CommonModelService
implements AreaService {
    private final ConcurrentMap<Long, Field> fieldMap = new ConcurrentHashMap<Long, Field>();
    private final ConcurrentMap<Long, HelpLine> helpLineMap = new ConcurrentHashMap<Long, HelpLine>();
    private static long globalId = 0L;

    public final Collection<Field> findAllCurrentFields() {
        return this.fieldMap.values();
    }

    public final Field createNewField(String name, MultiPolygon geometry, String code) {
        Field field = new Field();
        field.setName(name);
        field.setGeometry((Geometry)geometry);
        field.setCode(code);
        field.setAcreage(GeometryUtil.getAcreageInHA((Double)GeometryUtil.getAcreageFromGeometry((Geometry)geometry)));
        this.fieldMap.put(globalId++, field);
        return field;
    }

    public boolean endField(Field field) {
        Date now = new Date();
        if (field.getStartDate() == null || field.getStartDate().before(now)) {
            field.setEndDate(now);
            return true;
        }
        return false;
    }

    protected ExplorerManager initExplorer() {
        try {
            ExplorerManager manager = new ExplorerManager();
            FieldLayer fieldLayer = new FieldLayer("service.explorer.layerlist.field_node.name");
            Layer.Sync.SyncBaseExplorer((Layer)fieldLayer, (ExplorerManager)manager);
            HelpLineLayer lineLayer = new HelpLineLayer("service.explorer.layerlist.line_node.name");
            Layer.Sync.SyncBaseExplorer((Layer)lineLayer, (ExplorerManager)manager);
            manager.setRootContext((Node)new GeometryRootNode(fieldLayer, lineLayer));
            manager.getRootContext().setDisplayName(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"service.explorer.rootnode.displayname"));
            Layer.Sync.SyncBaseExplorer((Layer)fieldLayer, (ExplorerManager)manager);
            Layer.Sync.SyncBaseExplorer((Layer)lineLayer, (ExplorerManager)manager);
            return manager;
        }
        catch (IntrospectionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public Collection<HelpLine> findAllHelpLines() {
        return this.helpLineMap.values();
    }

    public void removeField(Field field) {
        this.endField(field);
        field.setEndDate(new Date());
        this.fieldMap.remove(field.getId());
    }

    public void removeHelpLine(HelpLine line) {
        this.helpLineMap.remove(line.getId());
    }

    public void createNewHelpLine(String name, MultiLineString geometry, String NAME) {
        HelpLine helpLine = new HelpLine();
        helpLine.setName(name);
        helpLine.setGeometry((Geometry)geometry);
        this.helpLineMap.put(globalId++, helpLine);
    }
}

